/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.bus;

import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.consumer.RPCBasicMessageListener;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.bus.Log;
import org.hawkular.inventory.bus.api.InventoryQueryRequestMessage;
import org.hawkular.inventory.bus.api.InventoryQueryResponseMessage;
import org.hawkular.inventory.bus.api.ResultSet;

public class QueryListener
extends RPCBasicMessageListener<InventoryQueryRequestMessage, InventoryQueryResponseMessage<?>> {
    private final Inventory inventory;
    private final ConnectionFactory contextFactory;
    private final String queueName;

    public QueryListener(Inventory inventory, ConnectionFactory contextFactory, String queName) throws JMSException {
        this.inventory = inventory;
        this.contextFactory = contextFactory;
        this.queueName = queName;
        ConnectionContextFactory factory = new ConnectionContextFactory(contextFactory);
        Endpoint endpoint = new Endpoint(Endpoint.Type.QUEUE, queName);
        ConsumerConnectionContext consumerConnectionContext = factory.createConsumerConnectionContext(endpoint);
        MessageProcessor processor = new MessageProcessor();
        processor.listen(consumerConnectionContext, (AbstractBasicMessageListener)this);
    }

    public InventoryQueryResponseMessage<?> onBasicMessage(BasicMessageWithExtraData<InventoryQueryRequestMessage> msgWithExtraData) {
        InventoryQueryRequestMessage message = (InventoryQueryRequestMessage)msgWithExtraData.getBasicMessage();
        Log.LOG.tracef("Query message received, entity = %s", message.getEntity().toString());
        Page page = this.inventory.execute(message.getQuery(), message.getEntity(), message.getPager());
        ResultSet resultSet = new ResultSet(page.toList(), page.getPageContext(), page.getTotalSize());
        InventoryQueryResponseMessage response = new InventoryQueryResponseMessage(resultSet, message.getEntity());
        return response;
    }
}

