/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.bus;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.bus.Log;
import org.hawkular.inventory.bus.api.InventoryEvent;

final class MessageSender {
    private final String topicName;
    private final TopicConnectionFactory topicConnectionFactory;
    private final MessageProcessor messageProcessor;

    public MessageSender(TopicConnectionFactory topicConnectionFactory, String topicName) {
        this.topicConnectionFactory = topicConnectionFactory;
        this.topicName = topicName;
        this.messageProcessor = new MessageProcessor();
    }

    public void send(Interest<?, ?> interest, Object inventoryEvent) {
        InventoryEvent message = InventoryEvent.from((Action)interest.getAction(), (Object)inventoryEvent);
        Map headers = message.createMessageHeaders();
        try (ConnectionContextFactory ccf = new ConnectionContextFactory((ConnectionFactory)this.topicConnectionFactory);){
            ProducerConnectionContext producerConnectionContext = ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, this.topicName));
            this.messageProcessor.send(producerConnectionContext, (BasicMessage)message, headers);
            Log.LOG.tracef("Sent message %s with headers %s to %s", message, headers, producerConnectionContext.getDestination());
        }
        catch (JMSException e) {
            Log.LOG.failedToSendMessage(message.toString());
        }
    }
}

