/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.bus;

import java.util.HashSet;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.bus.Configuration;
import org.hawkular.inventory.bus.MessageSender;
import rx.Subscription;

public final class BusIntegration {
    private final Inventory inventory;
    private MessageSender messageSender;
    private final Set<Subscription> subscriptions = new HashSet<Subscription>();
    private Configuration configuration;
    private InitialContext namingContext;

    public BusIntegration(Inventory inventory) {
        this.inventory = inventory;
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    public void start() throws NamingException, JMSException {
        if (this.namingContext != null) {
            return;
        }
        this.namingContext = new InitialContext();
        TopicConnectionFactory tcf = (TopicConnectionFactory)this.namingContext.lookup(this.configuration.getConnectionFactoryJndiName());
        this.messageSender = new MessageSender(tcf, this.configuration.getInventoryChangesTopicName());
        this.install();
    }

    public void stop() throws NamingException {
        this.uninstall();
        this.namingContext.close();
        this.namingContext = null;
    }

    private void install() {
        BusIntegration.install(this.inventory, this.subscriptions, Tenant.class, this.messageSender, new Action[0]);
        BusIntegration.install(this.inventory, this.subscriptions, ResourceType.class, this.messageSender, new Action[0]);
        BusIntegration.install(this.inventory, this.subscriptions, MetricType.class, this.messageSender, new Action[0]);
        BusIntegration.install(this.inventory, this.subscriptions, Environment.class, this.messageSender, Action.copied());
        BusIntegration.install(this.inventory, this.subscriptions, Feed.class, this.messageSender, Action.registered());
        BusIntegration.install(this.inventory, this.subscriptions, Resource.class, this.messageSender, new Action[0]);
        BusIntegration.install(this.inventory, this.subscriptions, Metric.class, this.messageSender, new Action[0]);
        BusIntegration.install(this.inventory, this.subscriptions, Relationship.class, this.messageSender, new Action[0]);
        BusIntegration.install(this.inventory, this.subscriptions, DataEntity.class, this.messageSender, new Action[0]);
    }

    private void uninstall() {
        this.subscriptions.forEach(Subscription::unsubscribe);
    }

    private static <U extends AbstractElement.Update, T extends AbstractElement<?, U>> void install(Inventory inventory, Set<Subscription> subscriptions, Class<T> entityClass, MessageSender sender, Action<?, T> ... additionalActions) {
        BusIntegration.installAction(inventory, subscriptions, entityClass, sender, Action.created());
        BusIntegration.installAction(inventory, subscriptions, entityClass, sender, Action.updated());
        BusIntegration.installAction(inventory, subscriptions, entityClass, sender, Action.deleted());
        for (Action<?, T> a : additionalActions) {
            BusIntegration.installAction(inventory, subscriptions, entityClass, sender, a);
        }
    }

    private static <C, T> void installAction(Inventory inventory, Set<Subscription> subscriptions, Class<T> entityClass, MessageSender sender, Action<C, T> action) {
        Interest interest = Interest.in(entityClass).being(action);
        Subscription s = inventory.observable(interest).subscribe(c -> sender.send(interest, c));
        subscriptions.add(s);
    }
}

