/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.bus;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.bus.Log;
import org.hawkular.inventory.bus.api.InventoryEvent;

final class MessageSender {
    private final String topicName;
    private final ConnectionFactory topicConnectionFactory;
    private final MessageProcessor messageProcessor;

    public MessageSender(ConnectionFactory topicConnectionFactory, String topicName) {
        this.topicConnectionFactory = topicConnectionFactory;
        this.topicName = topicName;
        this.messageProcessor = new MessageProcessor();
    }

    public void send(Interest<?, ?> interest, Tenant tenant, Object entity) {
        InventoryEvent message = InventoryEvent.from((Action)interest.getAction(), (Tenant)tenant, (Object)entity);
        Map headers = message.createMessageHeaders();
        message.setCorrelationId(new MessageId());
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(this.topicConnectionFactory);){
            ProducerConnectionContext producerConnectionContext = ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, this.topicName));
            this.messageProcessor.send(producerConnectionContext, (BasicMessage)message, headers);
            Log.LOG.tracef("Sent message %s with headers %s to %s", message, headers, producerConnectionContext.getDestination());
        }
        catch (JMSException e) {
            Log.LOG.failedToSendMessage(message.toString());
        }
    }
}

