/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.cdi;

import javax.enterprise.event.Event;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.cdi.AutoTenant;
import org.hawkular.inventory.cdi.AutoTenantInventoryInitialized;
import org.hawkular.inventory.cdi.Basic;
import org.hawkular.inventory.cdi.DisposingAutoTenantInventory;

@Singleton
public class AutoTenantInventoryProducer {
    @Inject
    @Basic
    private Inventory inventory;
    @Inject
    private Event<AutoTenantInventoryInitialized> autoTenantInventoryInitializedEvent;
    @Inject
    private Event<DisposingAutoTenantInventory> disposingAutoTenantInventoryEvent;

    @Produces
    @Singleton
    @AutoTenant
    public Inventory.Mixin.AutoTenant getInventory() {
        Inventory.Mixin.AutoTenant ret = Inventory.augment((Inventory)this.inventory).autoTenant().get();
        this.autoTenantInventoryInitializedEvent.fire((Object)new AutoTenantInventoryInitialized(ret));
        return ret;
    }

    public void close(@Disposes @AutoTenant Inventory.Mixin.AutoTenant inventory) throws Exception {
        this.disposingAutoTenantInventoryEvent.fire((Object)new DisposingAutoTenantInventory(inventory));
    }
}

