/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.cdi;

import javax.enterprise.event.Event;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.cdi.Basic;
import org.hawkular.inventory.cdi.DisposingObservableInventory;
import org.hawkular.inventory.cdi.Observable;
import org.hawkular.inventory.cdi.ObservableInventoryInitialized;

@Singleton
public class ObservableInventoryProducer {
    @Inject
    @Basic
    private Inventory inventory;
    @Inject
    private Event<ObservableInventoryInitialized> observableInventoryInitializedEvent;
    @Inject
    Event<DisposingObservableInventory> disposingObservableInventoryEvent;

    @Produces
    @Singleton
    @Observable
    public Inventory.Mixin.Observable getInventory() {
        Inventory.Mixin.Observable ret = Inventory.augment((Inventory)this.inventory).observable().get();
        this.observableInventoryInitializedEvent.fire((Object)new ObservableInventoryInitialized(ret));
        return ret;
    }

    public void close(@Disposes @Observable Inventory.Mixin.Observable inventory) throws Exception {
        this.disposingObservableInventoryEvent.fire((Object)new DisposingObservableInventory(inventory));
    }
}

