/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.cdi;

import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import java.io.File;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.feeds.AcceptWithFallbackFeedIdStrategy;
import org.hawkular.inventory.api.feeds.RandomUUIDFeedIdStrategy;
import org.hawkular.inventory.cdi.DisposingInventory;
import org.hawkular.inventory.cdi.InventoryInitialized;
import org.hawkular.inventory.cdi.Official;
import org.hawkular.inventory.impl.tinkerpop.TinkerpopInventory;

@Singleton
public class OfficialInventoryProducer {
    @Inject
    private Event<InventoryInitialized> inventoryInitializedEvent;
    @Inject
    private Event<DisposingInventory> disposingInventoryEvent;

    @Produces
    @Singleton
    @Official
    public Inventory getInventory() {
        Inventory inventory = this.initInventory();
        this.inventoryInitializedEvent.fire((Object)new InventoryInitialized(inventory));
        return inventory;
    }

    public void close(@Disposes @Official Inventory inventory) throws Exception {
        this.disposingInventoryEvent.fire((Object)new DisposingInventory(inventory));
        this.dispose(inventory);
    }

    private Inventory initInventory() {
        HashMap<String, String> config = new HashMap<String, String>();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> config.put(k.toString(), v == null ? null : v.toString())));
        if (config.get("blueprints.graph") == null) {
            config.put("blueprints.graph", DummyTransactionalGraph.class.getName());
        }
        if (config.get("blueprints.tg.directory") == null) {
            config.put("blueprints.tg.directory", new File((String)config.get("jboss.server.data.dir"), "hawkular-inventory").getAbsolutePath());
        }
        TinkerpopInventory inventory = new TinkerpopInventory();
        inventory.initialize(Configuration.builder().withFeedIdStrategy((FeedIdStrategy)new AcceptWithFallbackFeedIdStrategy((FeedIdStrategy)new RandomUUIDFeedIdStrategy())).withConfiguration(config).build());
        return inventory;
    }

    private void dispose(Inventory inventory) throws Exception {
        if (inventory != null) {
            inventory.close();
        }
    }

    public static class DummyTransactionalGraph
    extends TinkerGraph
    implements TransactionalGraph {
        public DummyTransactionalGraph(org.apache.commons.configuration.Configuration configuration) {
            super(configuration);
        }

        public void commit() {
        }

        public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        }

        public void rollback() {
        }
    }
}

