/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.cdi;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.feeds.AcceptWithFallbackFeedIdStrategy;
import org.hawkular.inventory.api.feeds.RandomUUIDFeedIdStrategy;
import org.hawkular.inventory.cdi.DisposingInventory;
import org.hawkular.inventory.cdi.InventoryConfigurationData;
import org.hawkular.inventory.cdi.InventoryInitialized;
import org.hawkular.inventory.cdi.Log;
import org.hawkular.inventory.cdi.Official;

@Singleton
public class OfficialInventoryProducer {
    private static final Configuration.Property IMPL_PROPERTY = Configuration.Property.builder().withPropertyNameAndSystemProperty("hawkular.inventory.impl").withEnvironmentVariables(new String[]{"HAWKULAR_INVENTORY_IMPL"}).build();
    @Inject
    private Event<InventoryInitialized> inventoryInitializedEvent;
    @Inject
    private Event<DisposingInventory> disposingInventoryEvent;
    @Inject
    private Instance<InventoryConfigurationData> configData;

    @Produces
    @Singleton
    @Official
    public Inventory getInventory() throws InterruptedException {
        Inventory inventory = this.initInventory();
        this.inventoryInitializedEvent.fire((Object)new InventoryInitialized(inventory));
        return inventory;
    }

    public void close(@Disposes @Official Inventory inventory) throws Exception {
        this.disposingInventoryEvent.fire((Object)new DisposingInventory(inventory));
        this.dispose(inventory);
    }

    private Inventory initInventory() throws InterruptedException {
        HashMap config = new HashMap();
        if (!this.configData.isUnsatisfied()) {
            Properties conf = new Properties();
            try (Reader rdr = ((InventoryConfigurationData)this.configData.get()).open();){
                conf.load(rdr);
            }
            catch (IOException e) {
                Log.LOG.wCannotReadConfigurationFile(null, e);
            }
            conf.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> config.put(k.toString(), v == null ? null : v.toString())));
        }
        Configuration cfg = Configuration.builder().withFeedIdStrategy((FeedIdStrategy)new AcceptWithFallbackFeedIdStrategy((FeedIdStrategy)new RandomUUIDFeedIdStrategy())).withConfiguration(config).build();
        Inventory inventory = this.instantiateNew(cfg);
        Log.LOG.iUsingImplementation(inventory.getClass().getName());
        int failures = 0;
        int maxFailures = 5;
        boolean initialized = false;
        while (failures++ < maxFailures) {
            try {
                inventory.initialize(cfg);
                initialized = true;
            }
            catch (Exception e) {
                Log.LOG.debugf("Unable to initialize inventory, exception thrown: ", e);
                Log.LOG.wInitializationFailure(failures, maxFailures);
                Thread.sleep(1000L);
            }
        }
        if (!initialized) {
            throw new IllegalStateException("Could not initialize inventory.");
        }
        Log.LOG.iInitialized();
        return inventory;
    }

    private void dispose(Inventory inventory) throws Exception {
        if (inventory != null) {
            inventory.close();
        }
    }

    private Inventory instantiateNew(Configuration config) {
        String implClass = config.getProperty(IMPL_PROPERTY, null);
        if (implClass != null) {
            try {
                return (Inventory)Class.forName(implClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Failed to instantiate inventory using class '" + implClass + "'.", e);
            }
        }
        return ServiceLoader.load(Inventory.class).iterator().next();
    }
}

