/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.cdi.AutoTenant;
import org.hawkular.inventory.rest.cdi.Our;
import org.hawkular.inventory.rest.security.RestConfiguration;
import org.hawkular.inventory.rest.security.Security;
import org.hawkular.inventory.rest.security.TenantIdProducer;
import org.jboss.resteasy.annotations.GZIP;

@GZIP
public class RestBase {
    @Inject
    @AutoTenant
    protected Inventory inventory;
    @Inject
    protected Security security;
    @Inject
    private TenantIdProducer tenantIdProducer;
    @Inject
    Configuration config;
    @Inject
    @Our
    protected ObjectMapper mapper;

    protected <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, Page<T> page) {
        return this.pagedResponse(response, uriInfo, this.mapper, page);
    }

    protected <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, ObjectMapper mapper, Page<T> page) {
        boolean streaming = this.config.getFlag((Configuration.Property)RestConfiguration.Keys.STREAMING_SERIALIZATION, RestConfiguration.Keys.STREAMING_SERIALIZATION.getDefaultValue());
        if (streaming) {
            return ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, (ObjectMapper)mapper, page);
        }
        try {
            return ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, page, (Object)mapper.writeValueAsString((Object)page.toList()));
        }
        catch (JsonProcessingException e) {
            RestApiLogger.LOGGER.warn((Throwable)e);
            return ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, page, (Object)page.toList());
        }
    }

    protected String getTenantId() {
        return this.tenantIdProducer.getTenantId().get();
    }
}

