/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Parents;
import org.hawkular.inventory.api.ReadInterface;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Metrics CRUD")
public class RestMetrics
extends RestBase {
    @POST
    @Path(value="/{environmentId}/metrics")
    @ApiOperation(value="Creates a new metric in given environment")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created"), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=409, message="Metric already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createMetric(@PathParam(value="environmentId") String environmentId, @ApiParam(required=true) Metric.Blueprint metric, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath env = (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get();
        if (!this.security.canCreate(Metric.class).under(env)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.createMetric((Metrics.ReadWrite)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).metrics(), metric);
        return ResponseUtil.created((UriInfo)uriInfo, (String)metric.getId()).build();
    }

    @POST
    @Path(value="/feeds/{feedId}/metrics")
    @ApiOperation(value="Creates a new metric in given feed")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created"), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=409, message="Metric already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createMetricInFeed(@PathParam(value="feedId") String feedId, @ApiParam(required=true) Metric.Blueprint metric, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath feed = (CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).get();
        if (!this.security.canCreate(Metric.class).under(feed)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.createMetric((Metrics.ReadWrite)((Feeds.Single)this.inventory.inspect(feed, Feeds.Single.class)).metrics(), metric);
        return ResponseUtil.created((UriInfo)uriInfo, (String)metric.getId()).build();
    }

    private void createMetric(Metrics.ReadWrite accessInterface, Metric.Blueprint metric) {
        if (metric == null) {
            throw new IllegalArgumentException("metric to create not specified");
        }
        if (metric.getId() == null) {
            throw new IllegalArgumentException("metric id not specified");
        }
        if (metric.getMetricTypePath() == null) {
            throw new IllegalArgumentException("metric type id not specified");
        }
        accessInterface.create((Blueprint)metric);
    }

    @GET
    @Path(value="/{environmentId}/metrics/{metricId}")
    @ApiOperation(value="Retrieves a single metric")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Rnvironment or metrics doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Metric getMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="metricId") String metricId) {
        return (Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).environments()).get((Object)environmentId)).metrics()).get((Object)metricId)).entity();
    }

    @GET
    @Path(value="/feeds/{feedId}/metrics/{metricId}")
    @ApiOperation(value="Retrieves a single metric")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Environment, feed or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Metric getMetricInFeed(@PathParam(value="feedId") String feedId, @PathParam(value="metricId") String metricId) {
        return (Metric)((Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).feeds()).get((Object)feedId)).metrics()).get((Object)metricId)).entity();
    }

    @GET
    @Path(value="/{environmentId}/metrics")
    @ApiOperation(value="Retrieves all metrics in an environment. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetrics(@PathParam(value="environmentId") String environmentId, @QueryParam(value="feedless") @DefaultValue(value="false") boolean feedless, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Environments.Single envs = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId);
        Page ret = ((Metrics.Multiple)(feedless ? (ReadInterface)envs.metrics() : envs.metricsUnder((Environments.MetricParents[])Parents.any())).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/feeds/{feedId}/metrics")
    @ApiOperation(value="Retrieves all metrics in a feed")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetrics(@PathParam(value="feedId") String feedId, @Context UriInfo uriInfo) {
        Page ret = ((Metrics.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).feeds()).get((Object)feedId)).metricsUnder((Feeds.MetricParents[])Parents.any()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @PUT
    @Path(value="/{environmentId}/metrics/{metricId}")
    @ApiOperation(value="Updates a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant, environment or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The update failed because of invalid data"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="metricId") String metricId, Metric.Update update) {
        String tenantId = this.getTenantId();
        CanonicalPath env = (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get();
        if (!this.security.canUpdate(env.extend(Metric.class, metricId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).metrics()).update((Object)metricId, (Object)update);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/feeds/{feedId}/metrics/{metricId}")
    @ApiOperation(value="Updates a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant, feed or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The update failed because of invalid data"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateMetricInFeed(@PathParam(value="feedId") String feedId, @PathParam(value="metricId") String metricId, Metric.Update update) {
        String tenantId = this.getTenantId();
        CanonicalPath feed = (CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).get();
        if (!this.security.canUpdate(feed.extend(Metric.class, metricId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Feeds.Single)this.inventory.inspect(feed, Feeds.Single.class)).metrics()).update((Object)metricId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{environmentId}/metrics/{metricId}")
    @ApiOperation(value="Deletes a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant, environment or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The delete failed because it would make inventory invalid"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="metricId") String metricId) {
        String tenantId = this.getTenantId();
        CanonicalPath env = (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get();
        if (!this.security.canDelete(env.extend(Metric.class, metricId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).metrics()).delete((Object)metricId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/feeds/{feedId}/metrics/{metricId}")
    @ApiOperation(value="Deletes a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, feed or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The delete failed because it would make inventory invalid"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteMetricInFeed(@PathParam(value="feedId") String feedId, @PathParam(value="metricId") String metricId) {
        String tenantId = this.getTenantId();
        CanonicalPath feed = (CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).get();
        if (!this.security.canDelete(feed.extend(Metric.class, metricId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Feeds.Single)this.inventory.inspect(feed, Feeds.Single.class)).metrics()).delete((Object)metricId);
        return Response.noContent().build();
    }
}

