/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestResources;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resource Data CRUD")
public class RestResourcesData
extends RestResources {
    @POST
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Creates the configuration for pre-existing resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant, environment, resource or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfigurationF(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(required=true) DataEntity.Blueprint<Resources.DataRole> configuration, @Context UriInfo uriInfo) {
        return this.createConfigurationHelper(null, feedId, resourcePath, configuration, uriInfo);
    }

    @POST
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Creates the configuration for pre-existing resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfiguration(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(required=true) DataEntity.Blueprint<Resources.DataRole> configuration, @Context UriInfo uriInfo) {
        return this.createConfigurationHelper(environmentId, null, resourcePath, configuration, uriInfo);
    }

    private Response createConfigurationHelper(String environmentId, String feedId, String resourcePath, DataEntity.Blueprint<Resources.DataRole> configuration, UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (!this.security.canUpdate(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Data.ReadWrite)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).data()).create(configuration);
        return ResponseUtil.created((UriInfo)uriInfo, (String)((Resources.DataRole)configuration.getRole()).name()).build();
    }

    @GET
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Retrieves the configuration of a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getConfigurationF(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @DefaultValue(value="configuration") @QueryParam(value="dataType") Resources.DataRole dataType) {
        return this.getConfigurationHelper(null, feedId, resourcePath, dataType);
    }

    @GET
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Retrieves the configuration of a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getConfiguration(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @DefaultValue(value="configuration") @QueryParam(value="dataType") Resources.DataRole dataType) {
        return this.getConfigurationHelper(environmentId, null, resourcePath, dataType);
    }

    private Response getConfigurationHelper(String environmentId, String feedId, String resourcePath, Resources.DataRole dataType) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        DataEntity data = ((Data.Single)((Data.ReadWrite)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).data()).get((Object)dataType)).entity();
        return Response.ok((Object)data).build();
    }

    @PUT
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Updates the configuration of a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateConfigurationF(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @DefaultValue(value="configuration") @QueryParam(value="dataType") Resources.DataRole dataType, @ApiParam(required=true) DataEntity.Update configuration) {
        return this.updateConfigurationHelper(null, feedId, resourcePath, dataType, configuration);
    }

    @PUT
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Updates the configuration of a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateConfiguration(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @DefaultValue(value="configuration") @QueryParam(value="dataType") Resources.DataRole dataType, @ApiParam(required=true) DataEntity.Update configuration) {
        return this.updateConfigurationHelper(environmentId, null, resourcePath, dataType, configuration);
    }

    private Response updateConfigurationHelper(String environmentId, String feedId, String resourcePath, Resources.DataRole dataType, DataEntity.Update configuration) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        ((Data.Single)((Data.ReadWrite)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).data()).get((Object)dataType)).update(configuration);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Deletes the configuration of a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteConfigurationF(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @DefaultValue(value="configuration") @QueryParam(value="dataType") Resources.DataRole dataType) {
        return this.deleteConfigurationHelper(null, feedId, resourcePath, dataType);
    }

    @DELETE
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/data")
    @ApiOperation(value="Deletes the configuration of a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteConfiguration(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @DefaultValue(value="configuration") @QueryParam(value="dataType") Resources.DataRole dataType) {
        return this.deleteConfigurationHelper(environmentId, null, resourcePath, dataType);
    }

    private Response deleteConfigurationHelper(String environmentId, String feedId, String resourcePath, Resources.DataRole dataType) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        ((Data.ReadWrite)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).data()).delete((Object)dataType);
        return Response.noContent().build();
    }
}

