/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestResources;
import org.hawkular.inventory.rest.json.ApiError;
import org.hawkular.inventory.rest.security.EntityIdUtils;

@javax.ws.rs.Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resource Metrics CRUD")
public class RestResourcesMetrics
extends RestResources {
    @POST
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Either creates a new metric owned by the resource or associates a pre-existing metric with the resource. This depends on what you pass as the the body of the request. A JSON array of strings is understood as a list of pre-existing metric paths that are associated with the resource. If the body is a JSON object or an array of JSON objects, the new metric or metrics are created \"underneath\" the resource.")
    @ApiResponses(value={@ApiResponse(code=201, message="New metric created under the resource"), @ApiResponse(code=204, message="Existing metric successfully associated"), @ApiResponse(code=404, message="Tenant, environment, resource doesn't exist. Also when an array of strings is supplied and one of the metrics in that array doesn't exist.", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateOrCreateMetrics(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="This is either a metric blueprint or a list of paths to metrics to be associated with the resource. They can either be canonical or relative to the resource.") Object metricPathsOrBlueprint, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        return this.createOrAssociateMetric(tenant, resource, metricPathsOrBlueprint, uriInfo);
    }

    @POST
    @javax.ws.rs.Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Either creates a new metric owned by the resource or associates a pre-existing metric with the resource. This depends on what you pass as the the body of the request. A JSON array of strings is understood as a list of pre-existing metric paths that are associated with the resource. If the body is a JSON object or an array of JSON objects, the new metric or metrics are created \"underneath\" the resource.")
    @ApiResponses(value={@ApiResponse(code=201, message="New metric created under the resource"), @ApiResponse(code=204, message="Existing metric successfully associated"), @ApiResponse(code=404, message="Tenant, environment, resource doesn't exist. Also when an array of strings is supplied and one of the metrics in that array doesn't exist.", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateOrCreateMetricsUnderFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="This is either a metric blueprint or a list of paths to metrics to be associated with the resource. They can either be canonical or relative to the resource.") Object metricPathsOrBlueprint, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        return this.createOrAssociateMetric(tenant, resource, metricPathsOrBlueprint, uriInfo);
    }

    private Response createOrAssociateMetric(CanonicalPath tenant, CanonicalPath resource, Object metricPathsOrBlueprint, UriInfo uriInfo) {
        BiConsumer<Map, Metrics.ReadWrite> createMetric = (map, access) -> {
            Metric.Blueprint blueprint = (Metric.Blueprint)this.mapper.convertValue(map, Metric.Blueprint.class);
            access.create((Blueprint)blueprint);
        };
        if (metricPathsOrBlueprint instanceof List) {
            List list = (List)metricPathsOrBlueprint;
            if (list.isEmpty()) {
                return Response.noContent().build();
            }
            if (list.get(0) instanceof Map) {
                if (!this.security.canCreate(Metric.class).under(resource)) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                Metrics.ReadWrite metricDao = (Metrics.ReadWrite)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics();
                list.forEach(m -> createMetric.accept((Map)m, metricDao));
                if (list.size() == 1) {
                    Metric.Blueprint blueprint = (Metric.Blueprint)this.mapper.convertValue(list.get(0), Metric.Blueprint.class);
                    return ResponseUtil.created((UriInfo)uriInfo, (String)blueprint.getId()).build();
                }
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
            if (!this.security.canAssociateFrom(resource)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Metrics.ReadAssociate metricDao = (Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).allMetrics();
            list.stream().map(p -> Path.fromPartiallyUntypedString((String)((String)p), (CanonicalPath)tenant, (CanonicalPath)resource, Metric.class)).forEach(x$0 -> metricDao.associate(x$0));
            return Response.noContent().build();
        }
        if (metricPathsOrBlueprint instanceof Map) {
            if (!this.security.canCreate(Metric.class).under(resource)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Metrics.ReadWrite metricDao = (Metrics.ReadWrite)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics();
            createMetric.accept((Map)metricPathsOrBlueprint, metricDao);
            Metric.Blueprint blueprint = (Metric.Blueprint)this.mapper.convertValue(metricPathsOrBlueprint, Metric.Blueprint.class);
            return ResponseUtil.created((UriInfo)uriInfo, (String)blueprint.getId()).build();
        }
        throw new IllegalArgumentException("Unhandled type of input");
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetrics(@PathParam(value="environmentId") String environmentID, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        CanonicalPath resource = this.composeCanonicalPath(this.getTenantId(), environmentID, null, resourcePath);
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).allMetrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ms).build();
    }

    @GET
    @javax.ws.rs.Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetricsF(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        CanonicalPath resource = this.composeCanonicalPath(this.getTenantId(), null, feedId, resourcePath);
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).allMetrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ms).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Retrieves a single metric associated with a resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetric(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (EntityIdUtils.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).allMetrics()).get((Object)mp)).entity();
        return Response.ok((Object)m).build();
    }

    @GET
    @javax.ws.rs.Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, feed, resource or metric doesn't exist or if the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetricF(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (EntityIdUtils.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).allMetrics()).get((Object)mp)).entity();
        return Response.ok((Object)m).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Disassociates the given resource from the given metric. If the metric is contained within the resource, it is also deleted.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetric(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        return this.disassociateOrDelete(tenant, rp, metricPath, isCanonical);
    }

    @DELETE
    @javax.ws.rs.Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Disassociates the given resource from the given metric. If the metric is contained within the resource, it is also deleted.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetricF(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        return this.disassociateOrDelete(tenant, rp, metricPath, isCanonical);
    }

    private Response disassociateOrDelete(CanonicalPath tenant, CanonicalPath resource, String metricPath, boolean isCanonical) {
        Path mp;
        if (!this.security.canAssociateFrom(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (EntityIdUtils.isTenantEscapeAttempt((CanonicalPath)resource, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)resource, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (mp.isRelative()) {
            mp = mp.toRelativePath().applyTo(resource);
        }
        if (mp.toCanonicalPath().up().equals((Object)resource)) {
            ((Metrics.ReadWrite)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics()).delete((Object)mp.getSegment().getElementId());
        } else {
            ((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).allMetrics()).disassociate(mp);
        }
        return Response.noContent().build();
    }
}

