/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.cdi.DisposingInventory;
import org.hawkular.inventory.cdi.InventoryInitialized;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.security.EntityIdUtils;
import org.hawkular.inventory.rest.security.SecurityIntegration;
import rx.Subscription;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
public class SecurityIntegration {
    @Inject
    ResourceService storage;
    @Inject
    PersonaService personas;
    private static final boolean DUMMY = false;
    private final Set<Subscription> subscriptions = new HashSet();
    private static final Map<String, Class> nameToclass = new HashMap();

    public void start(@Observes InventoryInitialized event) {
        if (!SecurityIntegration.isDummy()) {
            Inventory inventory = event.getInventory();
            this.install(inventory, Tenant.class);
            this.install(inventory, Environment.class);
            this.install(inventory, Feed.class);
            this.install(inventory, ResourceType.class);
            this.install(inventory, MetricType.class);
            this.install(inventory, Resource.class);
            this.install(inventory, Metric.class);
            this.install(inventory, OperationType.class);
            this.install(inventory, MetadataPack.class);
        }
    }

    public void stop(@Observes DisposingInventory event) {
        if (!SecurityIntegration.isDummy()) {
            this.subscriptions.forEach(Subscription::unsubscribe);
            this.subscriptions.clear();
        }
    }

    private <E extends AbstractElement<?, ?>> void install(Inventory inventory, Class<E> cls) {
        this.subscriptions.add(inventory.observable(Interest.in(cls).being(Action.created())).subscribe(e -> this.react(e, Action.created())));
        this.subscriptions.add(inventory.observable(Interest.in(cls).being(Action.deleted())).subscribe(e -> this.react(e, Action.deleted())));
        nameToclass.put(cls.getSimpleName().toLowerCase(), cls);
    }

    public static <E extends AbstractElement<?, ?>> Class<E> getClassFromName(String name) {
        return (Class)nameToclass.get(name);
    }

    @Transactional
    public void react(AbstractElement<?, ?> entity, Action<?, ?> action) {
        if (!SecurityIntegration.isDummy()) {
            switch (1.$SwitchMap$org$hawkular$inventory$api$Action$Enumerated[action.asEnum().ordinal()]) {
                case 1: {
                    this.createSecurityResource(entity.getPath());
                    break;
                }
                case 2: {
                    String stableId = EntityIdUtils.getStableId(entity);
                    this.storage.delete(stableId);
                    RestApiLogger.LOGGER.debugf("Deleted security entity with stable ID '%s' for entity %s", (Object)stableId, entity);
                }
            }
        }
    }

    private org.hawkular.accounts.api.model.Resource createSecurityResource(CanonicalPath path) {
        if (!path.isDefined()) {
            return null;
        }
        RestApiLogger.LOGGER.tracef("Creating security entity for %s", (Object)path);
        String stableId = EntityIdUtils.getStableId((CanonicalPath)path);
        org.hawkular.accounts.api.model.Resource res = this.storage.get(stableId);
        if (res == null) {
            org.hawkular.accounts.api.model.Resource parent = this.createSecurityResource(path.up());
            Persona owner = this.personas.getCurrent();
            if (parent != null) {
                owner = this.establishOwner(parent, owner);
            }
            res = this.storage.create(stableId, parent, owner);
            RestApiLogger.LOGGER.debugf("Created security entity with stable ID '%s' for entity %s", (Object)stableId, (Object)path);
        }
        return res;
    }

    private Persona establishOwner(org.hawkular.accounts.api.model.Resource resource, Persona current) {
        while (resource != null && resource.getPersona() == null) {
            resource = resource.getParent();
        }
        if (resource != null && resource.getPersona().equals((Object)current)) {
            current = null;
        }
        return current;
    }

    public static boolean isDummy() {
        return false;
    }
}

