/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@javax.ws.rs.Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Manages associations between resource types and metric types", tags={"ResourceTypes MetricTypes"})
public class RestResourceTypesMetricTypes
extends RestBase {
    @GET
    @javax.ws.rs.Path(value="/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Retrieves all metric types associated with the resource type. Accepts paging query params.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of metric types associated with the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetricTypes(@PathParam(value="resourceTypeId") String resourceTypeId, @Context UriInfo uriInfo) {
        Page ret = ((MetricTypes.Multiple)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).resourceTypes()).get((Object)resourceTypeId)).metricTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @POST
    @javax.ws.rs.Path(value="/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Associates a pre-existing metric type with a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, resource type or metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateMetricTypes(@PathParam(value="resourceTypeId") String resourceTypeId, @ApiParam(value="A list of paths to metric types to be associated with the resource type. They can either be canonical or relative to the resource type.") Collection<String> metricTypePaths) {
        String tenantId = this.getTenantId();
        if (!this.security.canAssociateFrom((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).resourceType(resourceTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rt = tenant.extend(ResourceType.class, resourceTypeId).get();
        MetricTypes.ReadAssociate metricTypesDao = (MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).resourceTypes()).get((Object)resourceTypeId)).metricTypes();
        metricTypePaths.stream().map(p -> Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenant, (CanonicalPath)rt, MetricType.class)).forEach(x$0 -> metricTypesDao.associate(x$0));
        return Response.noContent().build();
    }

    @GET
    @javax.ws.rs.Path(value="/resourceTypes/{resourceTypeId}/metricTypes/{metricTypePath:.+}")
    @ApiOperation(value="Retrieves the given metric type associated with the given resource type.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metric types"), @ApiResponse(code=404, message="Tenant or resource type does not exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public MetricType getAssociatedMetricType(@PathParam(value="resourceTypeId") String resourceTypeId, @Encoded @PathParam(value="metricTypePath") String metricTypePath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric type path should be considered canonical, false by default.") boolean isCanonical) {
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get();
        CanonicalPath rt = tenant.extend(ResourceType.class, resourceTypeId).get();
        if (isCanonical) {
            metricTypePath = "/" + metricTypePath;
        }
        Path mtPath = Path.fromPartiallyUntypedString((String)metricTypePath, (CanonicalPath)tenant, (CanonicalPath)rt, MetricType.class);
        return (MetricType)((MetricTypes.Single)((MetricTypes.ReadAssociate)((ResourceTypes.Single)this.inventory.inspect(rt, ResourceTypes.Single.class)).metricTypes()).get((Object)mtPath)).entity();
    }

    @GET
    @javax.ws.rs.Path(value="/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Retrieves metric types associated with the given resource type. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metric types"), @ApiResponse(code=404, message="Tenant or resource type does not exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetricTypes(@PathParam(value="resourceTypeId") String resourceTypeId, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Page mTypes = ((MetricTypes.Multiple)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).resourceTypes()).get((Object)resourceTypeId)).metricTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, mTypes).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/resourceTypes/{resourceTypeId}/metricTypes/{metricTypePath:.+}")
    @ApiOperation(value="Disassociates the given resource type from the given metric type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant or resource type does not exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetricType(@PathParam(value="resourceTypeId") String resourceTypeId, @Encoded @PathParam(value="metricTypePath") String metricTypePath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get();
        CanonicalPath rt = tenant.extend(ResourceType.class, resourceTypeId).get();
        if (!this.security.canAssociateFrom(rt)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (isCanonical) {
            metricTypePath = "/" + metricTypePath;
        }
        Path mtPath = Path.fromPartiallyUntypedString((String)metricTypePath, (CanonicalPath)tenant, (CanonicalPath)rt, MetricType.class);
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)this.inventory.inspect(rt, ResourceTypes.Single.class)).metricTypes()).disassociate(mtPath);
        return Response.noContent().build();
    }

    @GET
    @javax.ws.rs.Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Retrieves all metric types associated with the resource type. Accepts paging query params.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of metric types associated with the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetricTypes(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @Context UriInfo uriInfo) {
        Page ret = ((MetricTypes.Multiple)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).feeds()).get((Object)feedId)).resourceTypes()).get((Object)resourceTypeId)).metricTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @POST
    @javax.ws.rs.Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Associates a pre-existing metric type with a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, resource type or metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateMetricTypes(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @ApiParam(value="A list of paths to metric types to be associated with the resource type. They can either be canonical or relative to the resource type.") Collection<String> metricTypePaths) {
        String tenantId = this.getTenantId();
        if (!this.security.canAssociateFrom((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).resourceType(resourceTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rt = tenant.extend(Feed.class, feedId).extend(ResourceType.class, resourceTypeId).get();
        MetricTypes.ReadAssociate metricTypesDao = (MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)feedId)).resourceTypes()).get((Object)resourceTypeId)).metricTypes();
        metricTypePaths.stream().map(p -> Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenant, (CanonicalPath)rt, MetricType.class)).forEach(x$0 -> metricTypesDao.associate(x$0));
        return Response.noContent().build();
    }

    @GET
    @javax.ws.rs.Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/metricTypes/{metricTypePath:.+}")
    @ApiOperation(value="Retrieves the given metric type associated with the given resource type.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metric types"), @ApiResponse(code=404, message="Tenant or resource type does not exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public MetricType getAssociatedMetricType(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @Encoded @PathParam(value="metricTypePath") String metricTypePath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric type path should be considered canonical, false by default.") boolean isCanonical) {
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get();
        CanonicalPath rt = tenant.extend(Feed.class, feedId).extend(ResourceType.class, resourceTypeId).get();
        if (isCanonical) {
            metricTypePath = "/" + metricTypePath;
        }
        Path mtPath = Path.fromPartiallyUntypedString((String)metricTypePath, (CanonicalPath)tenant, (CanonicalPath)rt, MetricType.class);
        return (MetricType)((MetricTypes.Single)((MetricTypes.ReadAssociate)((ResourceTypes.Single)this.inventory.inspect(rt, ResourceTypes.Single.class)).metricTypes()).get((Object)mtPath)).entity();
    }

    @GET
    @javax.ws.rs.Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Retrieves metric types associated with the given resource type. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metric types"), @ApiResponse(code=404, message="Tenant or resource type does not exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetricTypes(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Page mTypes = ((MetricTypes.Multiple)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)feedId)).resourceTypes()).get((Object)resourceTypeId)).metricTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, mTypes).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/metricTypes/{metricTypePath:.+}")
    @ApiOperation(value="Disassociates the given resource type from the given metric type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant or resource type does not exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetricType(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @Encoded @PathParam(value="metricTypePath") String metricTypePath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get();
        CanonicalPath rt = tenant.extend(Feed.class, feedId).extend(ResourceType.class, resourceTypeId).get();
        if (!this.security.canAssociateFrom(rt)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (isCanonical) {
            metricTypePath = "/" + metricTypePath;
        }
        Path mtPath = Path.fromPartiallyUntypedString((String)metricTypePath, (CanonicalPath)tenant, (CanonicalPath)rt, MetricType.class);
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)this.inventory.inspect(rt, ResourceTypes.Single.class)).metricTypes()).disassociate(mtPath);
        return Response.noContent().build();
    }
}

