/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="CRUD of feeds", tags={"Feeds"})
public class RestFeeds
extends RestBase {
    @POST
    @Path(value="/feeds")
    @ApiOperation(value="Registers a feed with the inventory, giving it a unique ID.")
    @ApiResponses(value={@ApiResponse(code=201, message="OK", response=Feed.class), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response register(Feed.Blueprint blueprint, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        if (!this.security.canCreate(Feed.class).under(tenant)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Feed feed = (Feed)((Feeds.ReadWrite)((Tenants.Single)this.inventory.inspect(tenant, Tenants.Single.class)).feeds()).create(blueprint).entity();
        return ResponseUtil.created((AbstractElement)feed, (UriInfo)uriInfo, (String)feed.getId()).entity((Object)feed).build();
    }

    @GET
    @Path(value="/feeds")
    @ApiOperation(value="Return all the feeds registered with the inventory")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Set.class), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Page ret = ((Feeds.Multiple)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/feeds/{feedId}")
    @ApiOperation(value="Return a single feed by its ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Set.class), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response get(@PathParam(value="feedId") String feedId) {
        String tenantId = this.getTenantId();
        return Response.ok((Object)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)feedId)).entity()).build();
    }

    @PUT
    @Path(value="/feeds/{feedId}")
    @ApiOperation(value="Updates a feed")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Environment or the feed doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The update failed because of invalid data"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="feedId") String feedId, Feed.Update update) {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).update((Object)feedId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/feeds/{feedId}")
    @ApiOperation(value="Deletes a feed")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Environment or the feed doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The delete failed because it would make inventory invalid"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="feedId") String feedId) {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).delete((Object)feedId);
        return Response.noContent().build();
    }
}

