/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.MetadataPacks;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/metadatapacks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/metadatapacks", description="CRUD for the metadata packs.", tags={"Metadata packs"})
public class RestMetadataPacks
extends RestBase {
    @GET
    @Path(value="/")
    @ApiOperation(value="Retrieves all metadata packs.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Feed.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        return this.pagedResponse(Response.ok(), uriInfo, ((MetadataPacks.Multiple)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metadataPacks()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo))).build();
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Create a metadata pack")
    @ApiResponses(value={})
    public Response create(@ApiParam(required=true) MetadataPack.Blueprint blueprint, @Context UriInfo ui) {
        String tenantId = this.getTenantId();
        if (!this.security.canCreate(MetadataPack.class).under((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        MetadataPack ret = (MetadataPack)((MetadataPacks.Single)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metadataPacks()).create((Blueprint)blueprint)).entity();
        return ResponseUtil.created((AbstractElement)ret, (UriInfo)ui, (String)ret.getId()).entity((Object)ret).build();
    }

    @PUT
    @Path(value="/{id}")
    @ApiOperation(value="Update a metadata pack.")
    @ApiResponses(value={})
    public Response update(@PathParam(value="id") String id, @ApiParam(required=true) MetadataPack.Update update) {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)((CanonicalPath.MetadataPackBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).metadataPack(id)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metadataPacks()).update((Object)id, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Deletes a metadata pack.")
    @ApiResponses(value={})
    public Response delete(@PathParam(value="id") String id) {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)((CanonicalPath.MetadataPackBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).metadataPack(id)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metadataPacks()).delete((Object)id);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Get a single metadata pack by id.")
    @ApiResponses(value={})
    public MetadataPack get(@PathParam(value="id") String id) {
        String tenantId = this.getTenantId();
        return (MetadataPack)((MetadataPacks.Single)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metadataPacks()).get((Object)id)).entity();
    }

    @GET
    @Path(value="/{id}/resourceTypes")
    @ApiOperation(value="Retrieve all the resource types of the metadata pack.")
    @ApiResponses(value={})
    public Response getResourceTypes(@PathParam(value="id") String id, @Context UriInfo ui) {
        String tenantId = this.getTenantId();
        return this.pagedResponse(Response.ok(), ui, ((ResourceTypes.Multiple)((MetadataPacks.Single)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metadataPacks()).get((Object)id)).resourceTypes().getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)ui))).build();
    }

    @GET
    @Path(value="/{id}/metricTypes")
    @ApiOperation(value="Retrieve all the metric types of the metadata pack.")
    @ApiResponses(value={})
    public Response getMetricTypes(@PathParam(value="id") String id, @Context UriInfo ui) {
        String tenantId = this.getTenantId();
        return this.pagedResponse(Response.ok(), ui, ((MetricTypes.Multiple)((MetadataPacks.Single)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metadataPacks()).get((Object)id)).metricTypes().getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)ui))).build();
    }
}

