/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.cdi.AutoTenant;
import org.hawkular.inventory.rest.cdi.Our;
import org.hawkular.inventory.rest.security.RestConfiguration;
import org.hawkular.inventory.rest.security.Security;
import org.hawkular.inventory.rest.security.TenantIdProducer;
import org.jboss.resteasy.annotations.GZIP;

@GZIP
public class RestBase {
    @Inject
    @AutoTenant
    protected Inventory inventory;
    @Inject
    protected Security security;
    @Inject
    private TenantIdProducer tenantIdProducer;
    @Inject
    Configuration config;
    @Inject
    @Our
    protected ObjectMapper mapper;

    protected <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, Page<T> page) {
        return this.pagedResponse(response, uriInfo, this.mapper, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, ObjectMapper mapper, Page<T> page) {
        boolean streaming = this.config.getFlag((Configuration.Property)RestConfiguration.Keys.STREAMING_SERIALIZATION, RestConfiguration.Keys.STREAMING_SERIALIZATION.getDefaultValue());
        if (streaming) {
            return ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, (ObjectMapper)mapper, page);
        }
        try {
            RestApiLogger.LOGGER.debug((Object)"Fetching data from backend");
            List data = page.toList();
            RestApiLogger.LOGGER.debug((Object)"Finished fetching data from backend");
            Response.ResponseBuilder responseBuilder = ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, page, (Object)mapper.writeValueAsString((Object)data));
            return responseBuilder;
        }
        catch (JsonProcessingException e) {
            RestApiLogger.LOGGER.warn((Throwable)e);
            Response.ResponseBuilder responseBuilder = ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, page, (Object)page.toList());
            return responseBuilder;
        }
        finally {
            RestApiLogger.LOGGER.debug((Object)"Finished building paged response (no data sent to client yet)");
        }
    }

    protected String getTenantId() {
        return this.tenantIdProducer.getTenantId().get();
    }

    protected CanonicalPath parsePath(List<PathSegment> uriPath) {
        StringBuilder bld = new StringBuilder("/");
        for (PathSegment seg : uriPath) {
            if (seg.getPath() != null) {
                bld.append(seg.getPath());
            }
            if (seg.getMatrixParameters() != null) {
                for (Map.Entry e : seg.getMatrixParameters().entrySet()) {
                    String param = (String)e.getKey();
                    List values = (List)e.getValue();
                    if (values != null && !values.isEmpty()) {
                        for (String val : values) {
                            bld.append(";").append(param);
                            if (val == null) continue;
                            bld.append("=").append(val);
                        }
                        continue;
                    }
                    bld.append(";").append(param);
                }
            }
            bld.append("/");
        }
        bld.replace(bld.length() - 1, bld.length(), "");
        return CanonicalPath.fromPartiallyUntypedString((String)bld.toString(), (CanonicalPath)((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get()), Entity.class);
    }
}

