/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="CRUD of environments.", tags={"Environments"})
public class RestEnvironments
extends RestBase {
    @GET
    @Path(value="/environments")
    @ApiOperation(value="Returns all environments under given tenant. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Set.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@Context UriInfo uri) throws Exception {
        String tenantId = this.getTenantId();
        Page ret = ((Environments.Multiple)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uri));
        return this.pagedResponse(Response.ok(), uri, ret).build();
    }

    @GET
    @Path(value="/environments/{environmentId}")
    @ApiOperation(value="Retrieves a single environment")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response get(@PathParam(value="environmentId") String environmentId) throws Exception {
        String tenantId = this.getTenantId();
        return Response.ok((Object)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId)).entity()).build();
    }

    @POST
    @Path(value="/environments")
    @ApiOperation(value="Creates a new environment in given tenant.")
    @ApiResponses(value={@ApiResponse(code=201, message="Environment created"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=409, message="Environment already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(@ApiParam(required=true) Environment.Blueprint environmentBlueprint, @Context UriInfo uriInfo) throws Exception {
        String tenantId = this.getTenantId();
        if (!this.security.canCreate(Environment.class).under((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Environment entity = (Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).create((Blueprint)environmentBlueprint)).entity();
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)environmentBlueprint.getId()).build();
    }

    @PUT
    @Path(value="/environments/{environmentId}")
    @ApiOperation(value="Updates properties of the environment")
    @ApiResponses(value={@ApiResponse(code=204, message="The properties of the environment successfully updated"), @ApiResponse(code=400, message="Properties invalid", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant or environment not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="environmentId") String environmentId, @ApiParam(required=true) Environment.Update update) throws Exception {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).update((Object)environmentId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/environments/{environmentId}")
    @ApiOperation(value="Deletes the environment from the tenant")
    @ApiResponses(value={@ApiResponse(code=204, message="Environment successfully deleted"), @ApiResponse(code=400, message="Delete failed because it would leave inventory in invalid state", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant or environment not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="environmentId") String environmentId) throws Exception {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).delete((Object)environmentId);
        return Response.noContent().build();
    }
}

