/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="CRUD for operation type data", tags={"ResourceTypes OperationTypes Data"})
public class RestResourceTypesOperationTypesData
extends RestBase {
    @POST
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Creates the configuration for pre-existing resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfiguration(@PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @ApiParam(required=true) DataEntity.Blueprint<DataRole.OperationType> configuration, @Context UriInfo uriInfo) {
        return this.doCreateData(null, null, resourceType, operationTypeId, configuration, uriInfo);
    }

    @POST
    @Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Creates the configuration for pre-existing resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant, environment, resource type or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfiguration(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @ApiParam(required=true) DataEntity.Blueprint<DataRole.OperationType> configuration, @Context UriInfo uriInfo) {
        return this.doCreateData(null, feedId, resourceType, operationTypeId, configuration, uriInfo);
    }

    @PUT
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateData(@PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @QueryParam(value="dataType") @DefaultValue(value="returnType") DataRole.OperationType dataType, @ApiParam(required=true) DataEntity.Update data) {
        return this.doUpdateData(null, null, resourceType, operationTypeId, dataType, data);
    }

    @PUT
    @Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateData(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @QueryParam(value="dataType") @DefaultValue(value="returnType") DataRole.OperationType dataType, @ApiParam(required=true) DataEntity.Update data) {
        return this.doUpdateData(null, feedId, resourceType, operationTypeId, dataType, data);
    }

    @DELETE
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteData(@PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @QueryParam(value="dataType") @DefaultValue(value="returnType") DataRole.OperationType dataType) {
        return this.doDeleteData(null, null, resourceType, operationTypeId, dataType);
    }

    @DELETE
    @Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteData(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @QueryParam(value="dataType") @DefaultValue(value="returnType") DataRole.OperationType dataType) {
        return this.doDeleteData(null, feedId, resourceType, operationTypeId, dataType);
    }

    @GET
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public DataEntity get(@PathParam(value="resourceTypeId") String resourceTypeId, @PathParam(value="operationTypeId") String operationTypeId, @QueryParam(value="dataType") @DefaultValue(value="returnType") DataRole.OperationType dataType) {
        return this.doGetDataEntity(null, null, resourceTypeId, operationTypeId, dataType);
    }

    @GET
    @Path(value="/feeds/{feedId}/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}/data")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public DataEntity get(@PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @PathParam(value="operationTypeId") String operationTypeId, @QueryParam(value="dataType") @DefaultValue(value="returnType") DataRole.OperationType dataType) {
        return this.doGetDataEntity(null, feedId, resourceTypeId, operationTypeId, dataType);
    }

    private Response doCreateData(String environmentId, String feedId, String resourceTypeId, String operationTypeId, DataEntity.Blueprint<DataRole.OperationType> blueprint, UriInfo uriInfo) {
        CanonicalPath operationType = this.getOperationTypePath(environmentId, feedId, resourceTypeId, operationTypeId);
        if (!this.security.canUpdate(operationType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        DataEntity entity = ((Data.ReadWrite)((OperationTypes.Single)this.inventory.inspect(operationType, OperationTypes.Single.class)).data()).create(blueprint).entity();
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)((DataRole.OperationType)blueprint.getRole()).name()).build();
    }

    private Response doUpdateData(String environmentId, String feedId, String resourceTypeId, String operationTypeId, DataRole.OperationType dataType, DataEntity.Update update) {
        CanonicalPath operationType = this.getOperationTypePath(environmentId, feedId, resourceTypeId, operationTypeId);
        if (!this.security.canUpdate(operationType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Data.ReadWrite)((OperationTypes.Single)this.inventory.inspect(operationType, OperationTypes.Single.class)).data()).update((DataRole)dataType, update);
        return Response.noContent().build();
    }

    private Response doDeleteData(String environmentId, String feedId, String resourceTypeId, String operationTypeId, DataRole.OperationType dataType) {
        CanonicalPath operationType = this.getOperationTypePath(environmentId, feedId, resourceTypeId, operationTypeId);
        if (!this.security.canUpdate(operationType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Data.ReadWrite)((OperationTypes.Single)this.inventory.inspect(operationType, OperationTypes.Single.class)).data()).delete((Object)dataType);
        return Response.noContent().build();
    }

    private DataEntity doGetDataEntity(String environmentId, String feedId, String resourceTypeId, String operationTypeId, DataRole.OperationType dataType) {
        return ((Data.Single)((Data.ReadWrite)((OperationTypes.Single)this.inventory.inspect(this.getOperationTypePath(environmentId, feedId, resourceTypeId, operationTypeId), OperationTypes.Single.class)).data()).get((Object)dataType)).entity();
    }

    private CanonicalPath getOperationTypePath(String environmentId, String feedId, String resourceTypeId, String operationTypeId) {
        if (environmentId == null) {
            return (CanonicalPath)((CanonicalPath.OperationTypeBuilder)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).resourceType(resourceTypeId)).operationType(operationTypeId)).get();
        }
        return (CanonicalPath)((CanonicalPath.OperationTypeBuilder)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).feed(feedId)).resourceType(resourceTypeId)).operationType(operationTypeId)).get();
    }
}

