/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.integrated.inventory;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.hawkular.integrated.inventory.Log;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.cdi.InventoryInitialized;
import org.hawkular.inventory.paths.Path;
import rx.Observable;

@ApplicationScoped
public class TemporaryHacks {
    public void install(@Observes InventoryInitialized event) {
        Inventory inventory = event.getInventory();
        Observable tenantCreation = inventory.observable(Interest.in(Tenant.class).being(Action.created()));
        tenantCreation.subscribe(t -> this.createTenantMetadata(t, inventory), arg_0 -> ((Log)Log.LOGGER).failedToAutoCreateEntities(arg_0));
        tenantCreation.subscribe(t -> this.createTestEnvironment(t, inventory), arg_0 -> ((Log)Log.LOGGER).failedToAutoCreateEntities(arg_0));
        Observable feedCreation = inventory.observable(Interest.in(Feed.class).being(Action.created()));
        feedCreation.subscribe(f -> this.associateWithTestEnvironment(f, inventory), arg_0 -> ((Log)Log.LOGGER).failedToAutoCreateEntities(arg_0));
    }

    private void createTestEnvironment(Tenant tenant, Inventory inventory) {
        Environments.Single env = (Environments.Single)((Environments.ReadWrite)inventory.inspect(tenant).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("test")).build());
        Log.LOGGER.autoCreatedEntity("environment", "test", tenant.getId());
        Set allFeeds = ((Feeds.Multiple)((Feeds.ReadWrite)inventory.inspect(tenant).feeds()).getAll(new Filter[0])).entities();
        Set associatedFeeds = ((Feeds.Multiple)((Feeds.ReadAssociate)env.feeds()).getAll(new Filter[0])).entities();
        allFeeds.forEach(feed -> {
            if (!associatedFeeds.contains(feed)) {
                ((Feeds.ReadAssociate)env.feeds()).associate((Path)feed.getPath());
                Log.LOGGER.autoAssociatedFeed(feed.getPath().toString());
            }
        });
    }

    private void createTenantMetadata(Tenant tenant, Inventory inventory) {
        ((ResourceTypes.ReadWrite)inventory.inspect(tenant).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("URL")).build());
        Log.LOGGER.autoCreatedEntity("resource type", "URL", tenant.getId());
        ((MetricTypes.ReadWrite)inventory.inspect(tenant).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("status.code.type")).withUnit(MetricUnit.NONE).withInterval(Long.valueOf(20L)).build());
        Log.LOGGER.autoCreatedEntity("metric type", "status.code.type", tenant.getId());
        ((MetricTypes.ReadWrite)inventory.inspect(tenant).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("status.duration.type")).withUnit(MetricUnit.MILLISECONDS).withInterval(Long.valueOf(20L)).build());
        Log.LOGGER.autoCreatedEntity("metric type", "status.duration.type", tenant.getId());
    }

    private void associateWithTestEnvironment(Feed feed, Inventory inventory) {
        Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)feed.getPath().ids().getTenantId())).environments()).get((Object)"test");
        if (env.exists()) {
            ((Feeds.ReadAssociate)env.feeds()).associate((Path)feed.getPath());
            Log.LOGGER.autoAssociatedFeed(feed.getPath().toString());
        }
    }
}

