/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import org.hawkular.inventory.paths.CanonicalPath;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="HAWKINV")
public interface RestApiLogger
extends BasicLogger {
    public static final RestApiLogger LOGGER = (RestApiLogger)Logger.getMessageLogger(RestApiLogger.class, (String)"org.hawkular.inventory.rest");
    public static final RestApiLogger REQUESTS_LOGGER = (RestApiLogger)Logger.getMessageLogger(RestApiLogger.class, (String)"org.hawkular.inventory.rest.requests");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2000, value="Hawkular-Inventory REST Api is starting...")
    public void apiStarting();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2001, value="Something bad has happened")
    public void warn(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2002, value="Bus Integration initialization failed. Inventory will not notify about changes on the Hawkular message bus. Cause: [%s]")
    public void busInitializationFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2003, value="Security check failed on entity: [%s]")
    public void securityCheckFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2004, value="Accepting:\nHTTP %s -> %s\n\nheaders:\n%s\npayload:\n%s\njavaMethod: %s\n")
    public void restCall(String var1, String var2, String var3, String var4, String var5);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2005, value="Creating a resource under path '%s' is not implemented. This is a bug.")
    public void resourceCreationNotSupported(CanonicalPath var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2006, value="Error while creating entity on path '%s' during a bulk create.")
    public void failedToCreateBulkEntity(CanonicalPath var1, @Cause Throwable var2);
}

