/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.RestRelationships;
import org.hawkular.inventory.rest.json.ApiError;
import org.hawkular.inventory.rest.security.SecurityIntegration;
import rx.Subscription;
import rx.functions.Func1;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/events")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/events", description="Work with the events emitted by inventory", tags={"Events"})
public class RestEvents
extends RestBase {
    @Inject
    private RestRelationships restRelationships;

    @GET
    @Path(value="/")
    @ApiOperation(value="Listen on stream of the events")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public void getEvents(@Suspended AsyncResponse asyncResponse, @QueryParam(value="type") @DefaultValue(value="resource") String type, @QueryParam(value="action") @DefaultValue(value="created") String actionString) {
        Action.Enumerated actionEnumItem;
        String tenantId = this.getTenantId();
        Class cls = SecurityIntegration.getClassFromName((String)type);
        if (cls == null) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unknown type: " + type)).build());
        }
        try {
            actionEnumItem = Action.Enumerated.valueOf((String)actionString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            Optional<String> allowedValues = Arrays.stream(Action.Enumerated.values()).map(a -> a.name().toLowerCase() + " ").reduce(String::concat);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unknown action: " + actionString + ", allowed values: " + allowedValues.get())).build());
            return;
        }
        Action action = actionEnumItem.getAction();
        Subscription subscribe = this.inventory.observable(Interest.in((Class)cls).being(action)).filter(RestEvents.getFilter((Action)action, (String)tenantId)).buffer(20L, TimeUnit.SECONDS).subscribe(x -> asyncResponse.resume(x));
        asyncResponse.setTimeout(21L, TimeUnit.SECONDS);
        asyncResponse.setTimeoutHandler((TimeoutHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Func1<Object, Boolean> getFilter(Action<?, ?> action, String tenantId) {
        if (action == Action.updated()) {
            return e -> tenantId.equals(((AbstractElement)((Action.Update)e).getOriginalEntity()).getPath().ids().getTenantId());
        }
        if (action == Action.copied()) {
            return e -> tenantId.equals(((Action.EnvironmentCopy)e).getSource().getPath().ids().getTenantId());
        }
        return e -> {
            if (e instanceof Relationship) {
                return tenantId.equals(((Relationship)e).getSource().ids().getTenantId());
            }
            return tenantId.equals(((AbstractElement)e).getPath().ids().getTenantId());
        };
    }
}

