/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.hawkular.inventory.api.IdentityHashed;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.RestBase;

@Path(value="/sync")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/sync", description="Synchronization of entity trees", tags={"Sync"})
public class RestSync
extends RestBase {
    @POST
    @Path(value="/{path}")
    @ApiOperation(value="Make the inventory under given path match the provided inventory structure. Note that the relationships specified in the provided entities will be ignored and will not be applied.")
    @ApiResponses(value={@ApiResponse(code=204, message="Synchronization success")})
    public Response sync(@Encoded @PathParam(value="path") List<PathSegment> path, InventoryStructure.Offline<?> structure) {
        CanonicalPath cp = this.parsePath(path);
        if (!InventoryStructure.EntityType.supports((SegmentType)cp.getSegment().getElementType())) {
            throw new IllegalArgumentException("Entities of type " + cp.getSegment().getElementType().getSimpleName() + " are not synchronizable.");
        }
        ((IdentityHashed.SingleWithRelationships)this.inventory.inspect(cp, IdentityHashed.SingleWithRelationships.class)).synchronize(structure);
        return Response.noContent().build();
    }
}

