/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.json;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.ws.rs.Produces;
import org.hawkular.inventory.rest.json.LinkDeserializer;
import org.hawkular.inventory.rest.json.LinkSerializer;

@ApiModel(value="Link between two resources")
@JsonSerialize(using=LinkSerializer.class)
@JsonDeserialize(using=LinkDeserializer.class)
@Produces(value={"application/json"})
public class Link {
    private String rel;
    private String href;

    public Link() {
    }

    public Link(String rel, String href) {
        this.rel = rel;
        this.href = href;
    }

    @ApiModelProperty(value="Name of the relation")
    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    @ApiModelProperty(value="Target of the relation")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String toString() {
        return this.href + "; " + "rel='" + this.rel + '\'';
    }

    public String rfc5988String() {
        StringBuilder builder = new StringBuilder();
        builder.append("<").append(this.href).append(">; rel=\"").append(this.rel).append("\"");
        return builder.toString();
    }
}

