/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.security;

import java.util.UUID;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityIdUtils {
    public static String getStableId(CanonicalPath path) {
        return EntityIdUtils.shortenIfNeeded((CanonicalPath)path);
    }

    public static String getStableId(AbstractElement<?, ?> element) {
        return EntityIdUtils.getStableId((CanonicalPath)element.getPath());
    }

    public static CanonicalPath toCanonicalPath(String restPath) {
        String[] chunks = restPath.split("(?<=[^\\\\])/");
        CanonicalPath.Extender path = CanonicalPath.empty();
        if (chunks.length == 2) {
            if ("tenants".equals(chunks[0])) {
                path.extend(Tenant.SEGMENT_TYPE, chunks[1]);
            } else if ("relationships".equals(chunks[0])) {
                path.extend(Relationship.SEGMENT_TYPE, chunks[1]);
            }
        } else if (chunks.length == 3) {
            if ("environments".equals(chunks[1])) {
                path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(Environment.SEGMENT_TYPE, chunks[2]);
            } else if ("resourceTypes".equals(chunks[1])) {
                path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(ResourceType.SEGMENT_TYPE, chunks[2]);
            } else if ("metricTypes".equals(chunks[1])) {
                path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(MetricType.SEGMENT_TYPE, chunks[2]);
            } else if ("feeds".equals(chunks[1])) {
                path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(Feed.SEGMENT_TYPE, chunks[2]);
            }
        } else if (chunks.length == 4 && "resources".equals(chunks[2])) {
            path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(Environment.SEGMENT_TYPE, chunks[1]).extend(Resource.SEGMENT_TYPE, chunks[3]);
        } else if (chunks.length == 4 && "metrics".equals(chunks[2])) {
            path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(Environment.SEGMENT_TYPE, chunks[1]).extend(Metric.SEGMENT_TYPE, chunks[3]);
        } else if (chunks.length == 5 && "resources".equals(chunks[3])) {
            path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(Feed.SEGMENT_TYPE, chunks[2]).extend(Resource.SEGMENT_TYPE, chunks[4]);
        } else if (chunks.length == 5 && "metrics".equals(chunks[3])) {
            path.extend(Tenant.SEGMENT_TYPE, chunks[0]).extend(Feed.SEGMENT_TYPE, chunks[2]).extend(Metric.SEGMENT_TYPE, chunks[4]);
        }
        return path.get();
    }

    public static boolean isTenantEscapeAttempt(CanonicalPath origin, Path extension) {
        if (extension instanceof CanonicalPath) {
            return !((CanonicalPath)extension).ids().getTenantId().equals(origin.ids().getTenantId());
        }
        CanonicalPath target = ((RelativePath)extension).applyTo(origin);
        return !target.ids().getTenantId().equals(origin.ids().getTenantId());
    }

    private static String shortenIfNeeded(CanonicalPath path) {
        String id = path.toString();
        if (id.length() > 250) {
            return UUID.nameUUIDFromBytes(id.getBytes()).toString();
        }
        return id;
    }
}

