/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingleWithRelationships;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;
import org.hawkular.inventory.rest.json.JsonLd;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/.*/relationships", description="Work with the relationships.", tags={"Relationships"})
public class RestRelationships
extends RestBase {
    public static Map<String, Class<? extends Entity<?, ?>>> entityMap;
    @Context
    private Providers providers;
    @Inject
    @JsonLd
    private ObjectMapper jsonLdMapper;

    @GET
    @Path(value="{path:.*}/relationships")
    @ApiOperation(value="Retrieves relationships")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of relationships"), @ApiResponse(code=404, message="Accompanying entity doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response get(@PathParam(value="path") String path, @DefaultValue(value="both") @QueryParam(value="direction") String direction, @DefaultValue(value="") @QueryParam(value="property") String propertyName, @DefaultValue(value="") @QueryParam(value="propertyValue") String propertyValue, @DefaultValue(value="") @QueryParam(value="named") String named, @DefaultValue(value="") @QueryParam(value="sourceType") String sourceType, @DefaultValue(value="") @QueryParam(value="targetType") String targetType, @DefaultValue(value="false") @QueryParam(value="jsonld") String jsonLd, @Context UriInfo uriInfo) {
        String securityId = this.fixUpRestPath(path);
        CanonicalPath cPath = RequestUtil.toCanonicalPath((String)securityId);
        if (!cPath.isDefined()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ResolvableToSingleWithRelationships resolvable = this.getResolvableFromCanonicalPath(cPath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        RelationFilter[] filters = RestRelationships.extractFilters((String)propertyName, (String)propertyValue, (String)named, (String)sourceType, (String)targetType, (UriInfo)uriInfo);
        Relationships.Direction directed = Relationships.Direction.valueOf((String)direction);
        Page relations = ((Relationships.Multiple)((Relationships.ReadWrite)resolvable.relationships(directed)).getAll(filters)).entities(pager);
        boolean jsonLdBool = Boolean.parseBoolean(jsonLd);
        if (jsonLdBool) {
            return this.pagedResponse(Response.ok(), uriInfo, this.jsonLdMapper, relations).build();
        }
        return this.pagedResponse(Response.ok(), uriInfo, relations).build();
    }

    @GET
    @Path(value="/relationships/{relationshipId}")
    @ApiOperation(value="Retrieves relationship info")
    @ApiResponses(value={@ApiResponse(code=200, message="The details of relationship"), @ApiResponse(code=404, message="Accompanying entity doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getRelationship(@PathParam(value="relationshipId") String relationshipId, @DefaultValue(value="false") @QueryParam(value="jsonld") String jsonLd, @Context UriInfo uriInfo) throws JsonProcessingException {
        Relationship relationship = (Relationship)((Relationships.Single)this.inventory.relationships().get(relationshipId)).entity();
        ObjectMapper mapper = Boolean.parseBoolean(jsonLd) ? this.jsonLdMapper : this.mapper;
        String json = mapper.writeValueAsString((Object)relationship);
        return Response.ok((Object)json).build();
    }

    @DELETE
    @Path(value="{path:.*}/relationships")
    @ApiOperation(value="Deletes a relationship")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of relationships"), @ApiResponse(code=404, message="Accompanying entity doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="path") String path, @ApiParam(required=true) Relationship relation, @Context UriInfo uriInfo) {
        String securityId = this.fixUpRestPath(path);
        this.checkForWellKnownLabels(relation.getName(), "delete");
        CanonicalPath cPath = RequestUtil.toCanonicalPath((String)securityId);
        if (!cPath.isDefined()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ResolvableToSingleWithRelationships resolvable = this.getResolvableFromCanonicalPath(cPath);
        ((Relationships.ReadWrite)resolvable.relationships(Relationships.Direction.both)).delete(relation.getId());
        if (RestApiLogger.LOGGER.isDebugEnabled()) {
            RestApiLogger.LOGGER.debug((Object)("deleting relationship with id: " + relation.getId() + " and name: " + relation.getName()));
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="{path:.*}/relationships")
    @ApiOperation(value="Creates a relationship")
    @ApiResponses(value={@ApiResponse(code=201, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Accompanying entity doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Relationship already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(@PathParam(value="path") String path, @ApiParam(required=true) Relationship relation, @Context UriInfo uriInfo) {
        CanonicalPath theOtherSide;
        Relationships.Direction directed;
        String restPath = this.fixUpRestPath(path);
        this.checkForWellKnownLabels(relation.getName(), "create");
        CanonicalPath cPath = RequestUtil.toCanonicalPath((String)restPath);
        if (!cPath.isDefined()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ResolvableToSingleWithRelationships resolvable = this.getResolvableFromCanonicalPath(cPath);
        String[] chunks = path.split("/");
        String currentEntityId = cPath.getSegment().getElementId();
        if (currentEntityId.equals(relation.getSource().getSegment().getElementId())) {
            directed = Relationships.Direction.outgoing;
            theOtherSide = relation.getTarget();
        } else if (currentEntityId.equals(relation.getTarget().getSegment().getElementId())) {
            directed = Relationships.Direction.incoming;
            theOtherSide = relation.getSource();
        } else {
            throw new IllegalArgumentException("Either source or target of the relationship must correspond with the resource being modified.");
        }
        Relationship rel = (Relationship)((Relationships.Single)((Relationships.ReadWrite)resolvable.relationships(directed)).linkWith(relation.getName(), theOtherSide, relation.getProperties())).entity();
        String newId = rel.getId();
        if (RestApiLogger.LOGGER.isDebugEnabled()) {
            RestApiLogger.LOGGER.debug((Object)("creating relationship with id: " + newId + " and name: " + relation.getName()));
        }
        return ResponseUtil.created((AbstractElement)rel, (UriInfo)uriInfo, (String)newId).build();
    }

    @PUT
    @Path(value="{path:.*}/relationships")
    @ApiOperation(value="Updates a relationship")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Accompanying entity doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="path") String path, @ApiParam(required=true) Relationship relation, @Context UriInfo uriInfo) {
        String securityId = this.fixUpRestPath(path);
        this.checkForWellKnownLabels(relation.getName(), "update");
        CanonicalPath cPath = RequestUtil.toCanonicalPath((String)securityId);
        if (!cPath.isDefined()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ResolvableToSingleWithRelationships resolvable = this.getResolvableFromCanonicalPath(cPath);
        ((Relationships.ReadWrite)resolvable.relationships(Relationships.Direction.both)).update(relation.getId(), ((Relationship.Update.Builder)Relationship.Update.builder().withProperties(relation.getProperties())).build());
        if (RestApiLogger.LOGGER.isDebugEnabled()) {
            RestApiLogger.LOGGER.debug((Object)("updating relationship with id: " + relation.getId() + " and name: " + relation.getName()));
        }
        return Response.noContent().build();
    }

    private String fixUpRestPath(String urlPath) {
        if (urlPath == null) {
            return null;
        }
        return urlPath.startsWith("tenant") ? "tenants/" + this.getTenantId() : this.getTenantId() + "/" + urlPath;
    }

    private <E extends AbstractElement<?, U>, U extends AbstractElement.Update> ResolvableToSingleWithRelationships<E, U> getResolvableFromCanonicalPath(CanonicalPath cPath) {
        return (ResolvableToSingleWithRelationships)this.inventory.inspect(cPath, ResolvableToSingleWithRelationships.class);
    }

    public static RelationFilter[] extractFilters(String propertyName, String propertyValue, String named, String sourceType, String targetType, UriInfo info) {
        Class[] types;
        ArrayList<Object> filters = new ArrayList<Object>();
        if (!propertyName.isEmpty() && !propertyValue.isEmpty()) {
            filters.add(RelationWith.propertyValue((String)propertyName, (Object)propertyValue));
        }
        if (!named.isEmpty()) {
            List namedParam = (List)info.getQueryParameters().get((Object)"named");
            if (namedParam == null || namedParam.isEmpty()) {
                throw new IllegalArgumentException("Malformed URL param, the right format is: named=label1&named=label2&named=labelN");
            }
            filters.add(RelationWith.names((String[])namedParam.toArray(new String[namedParam.size()])));
        }
        if (!sourceType.isEmpty()) {
            List sourceParam = (List)info.getQueryParameters().get((Object)"sourceType");
            if (sourceParam == null || sourceParam.isEmpty()) {
                throw new IllegalArgumentException("Malformed URL param, the right format is: sourceType=type1&sourceType=type2&sourceType=typeN");
            }
            types = (Class[])sourceParam.stream().map(typeString -> (Class)entityMap.get(typeString)).toArray(Class[]::new);
            if (!sourceParam.isEmpty()) {
                filters.add(RelationWith.sourcesOfTypes((Class[])types));
            }
        }
        if (!targetType.isEmpty()) {
            List targetParam = (List)info.getQueryParameters().get((Object)"targetType");
            if (targetParam == null || targetParam.isEmpty()) {
                throw new IllegalArgumentException("Malformed URL param, the right format is: targetType=type1&targetType=type2&targetType=typeN");
            }
            types = (Class[])targetParam.stream().map(typeString -> (Class)entityMap.get(typeString)).toArray(Class[]::new);
            if (!targetParam.isEmpty()) {
                filters.add(RelationWith.targetsOfTypes((Class[])types));
            }
        }
        return filters.isEmpty() ? RelationFilter.all() : filters.toArray(new RelationFilter[filters.size()]);
    }

    private void checkForWellKnownLabels(String name, String operation) {
        if (Arrays.stream(Relationships.WellKnown.values()).anyMatch(x -> x.name().equals(name))) {
            throw new IllegalArgumentException("Unable to " + operation + " a relationship with well defined name. " + "Restricted names: " + Arrays.asList(Relationships.WellKnown.values()));
        }
    }

    static {
        try {
            entityMap = new HashMap(7);
            entityMap.put(Tenant.class.getSimpleName(), Tenant.class);
            entityMap.put(Environment.class.getSimpleName(), Environment.class);
            entityMap.put(ResourceType.class.getSimpleName(), ResourceType.class);
            entityMap.put(MetricType.class.getSimpleName(), MetricType.class);
            entityMap.put(Resource.class.getSimpleName(), Resource.class);
            entityMap.put(Metric.class.getSimpleName(), Metric.class);
            entityMap.put(Feed.class.getSimpleName(), Feed.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

