/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.filters.ResourceFilters;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resources CRUD", tags={"Resources"})
public class RestResources
extends RestBase {
    @POST
    @Path(value="/{environmentId}/resources")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addResource(@PathParam(value="environmentId") String environmentId, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath env = (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get();
        if (!this.security.canCreate(Resource.class).under(env)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Resource entity = (Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).resources()).create((Blueprint)resource)).entity();
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @POST
    @Path(value="/{environmentId}/resources/{parentPath:.+}")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addResource(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="parentPath") String parentPath, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, parentPath);
        if (!this.security.canCreate(Resource.class).under(parent)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Resource entity = (Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).resources()).create((Blueprint)resource)).entity();
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @POST
    @Path(value="/feeds/{feedId}/resources")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant or feed doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addFeedResource(@PathParam(value="feedId") String feedId, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath feed = (CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).get();
        if (!this.security.canCreate(Resource.class).under(feed)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Resource entity = (Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)this.inventory.inspect(feed, Feeds.Single.class)).resources()).create((Blueprint)resource)).entity();
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @POST
    @Path(value="/feeds/{feedId}/resources/{parentPath:.+}")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant or feed doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addFeedResource(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="parentPath") String parentPath, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, null, feedId, parentPath);
        if (!this.security.canCreate(Resource.class).under(parent)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Resource entity = (Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).resources()).create((Blueprint)resource)).entity();
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @GET
    @Path(value="/{environmentId}/resources")
    @ApiOperation(value="Retrieves resources in the environment, optionally filtering by resource type. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getResources(@PathParam(value="environmentId") String environmentId, @QueryParam(value="type") String typeId, @QueryParam(value="feedless") @DefaultValue(value="false") boolean feedless, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Environments.Single envs = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId);
        ResolvingToMultiple rr = feedless ? (ResolvingToMultiple)envs.resources() : (ResolvingToMultiple)envs.resources();
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        ResourceFilters filters = new ResourceFilters(tenantId, uriInfo.getQueryParameters());
        Page rs = ((Resources.Multiple)rr.getAll(filters.get())).entities(pager);
        return this.pagedResponse(Response.ok(), uriInfo, rs).build();
    }

    @GET
    @Path(value="/feeds/{feedId}/resources")
    @ApiOperation(value="Retrieves resources in the feed, optionally filtering by resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getResources(@PathParam(value="feedId") String feedId, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Resources.ReadWrite rr = (Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)feedId)).resources();
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        ResourceFilters filters = new ResourceFilters(tenantId, uriInfo.getQueryParameters());
        Page rs = ((Resources.Multiple)rr.getAll(filters.get())).entities(pager);
        return this.pagedResponse(Response.ok(), uriInfo, rs).build();
    }

    @GET
    @Path(value="/{environmentId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Resource getResource(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath) {
        CanonicalPath res = this.composeCanonicalPath(this.getTenantId(), environmentId, null, resourcePath);
        return (Resource)((Resources.Single)this.inventory.inspect(res, Resources.Single.class)).entity();
    }

    @GET
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Resource getResourceInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath) {
        CanonicalPath res = this.composeCanonicalPath(this.getTenantId(), null, feedId, resourcePath);
        return (Resource)((Resources.Single)this.inventory.inspect(res, Resources.Single.class)).entity();
    }

    @GET
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Retrieves child resources of a resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getChildren(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allResources()).getAll(new Filter[0])).entities(pager);
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Retrieves child resources of a resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getChildrenInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allResources()).getAll(new Filter[0])).entities(pager);
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/parents")
    @ApiOperation(value="Retrieves parents resources of the resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getParents(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).parents().getAll(new Filter[0])).entities(pager);
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/parents")
    @ApiOperation(value="Retrieves parent resources of a resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getParentsInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).parents().getAll(new Filter[0])).entities(pager);
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/parent")
    @ApiOperation(value="Retrieves the parent resources that contains the given resource. Such parent resource will not exist for resources directly contained in an environment or a feed.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Resource getParent(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        return (Resource)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).parent().entity();
    }

    @GET
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/parent")
    @ApiOperation(value="Retrieves the parent resources that contains the given resource. Such parent resource will not exist for resources directly contained in an environment or a feed.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment, feed or the resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Resource getParentInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        return (Resource)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).parent().entity();
    }

    @POST
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Associates given resources as children of a given resource.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response associateChildren(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="resources") Collection<String> resources) {
        String tenantId = this.getTenantId();
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        Resources.ReadAssociate access = (Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allResources();
        resources.stream().map(p -> org.hawkular.inventory.paths.Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenantPath, (CanonicalPath)parent, (SegmentType)Resource.SEGMENT_TYPE)).forEach(x$0 -> access.associate(x$0));
        return Response.noContent().build();
    }

    @POST
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Associates given resources as children of a given resource.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response associateChildrenInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="resources") Collection<String> resources) {
        String tenantId = this.getTenantId();
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        Resources.ReadAssociate access = (Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allResources();
        resources.stream().map(p -> org.hawkular.inventory.paths.Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenantPath, (CanonicalPath)parent, (SegmentType)Resource.SEGMENT_TYPE)).forEach(x$0 -> access.associate(x$0));
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/children/{childPath:.+}")
    @ApiOperation(value="Disassociates given child resource from given resource. The the resource doesn't own the child, the child will no longer be considered a child of the resource, otherwise an error will be returned.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="environment, the parent resource or the child resource not found", response=ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response disassociateChild(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="childPath") String childPath, @QueryParam(value="canonical") @DefaultValue(value="false") boolean isCanonical) {
        String tenantId = this.getTenantId();
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (isCanonical) {
            childPath = "/" + childPath;
        }
        org.hawkular.inventory.paths.Path child = org.hawkular.inventory.paths.Path.fromPartiallyUntypedString((String)childPath, (CanonicalPath)tenantPath, (CanonicalPath)parent, (SegmentType)Resource.SEGMENT_TYPE);
        ((Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allResources()).disassociate(child);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/children/{childPath:.+}")
    @ApiOperation(value="Disassociates given child resource from given resource. The the resource doesn't own the child, the child will no longer be considered a child of the resource, otherwise an error will be returned.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="feed, the parent resource or the child resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response disassociateChildInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="childPath") String childPath, @QueryParam(value="canonical") @DefaultValue(value="false") boolean isCanonical) {
        String tenantId = this.getTenantId();
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        if (isCanonical) {
            childPath = "/" + childPath;
        }
        org.hawkular.inventory.paths.Path child = org.hawkular.inventory.paths.Path.fromPartiallyUntypedString((String)childPath, (CanonicalPath)tenantPath, (CanonicalPath)parent, (SegmentType)Resource.SEGMENT_TYPE);
        ((Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allResources()).disassociate(child);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/{environmentId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Update a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(required=true) Resource.Update update) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canUpdate(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).update((Object)update);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Update a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(required=true) Resource.Update update) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        if (!this.security.canUpdate(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).update((Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{environmentId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Deletes a single resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteResource(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canDelete(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).delete();
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteResourceInFeed(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, null, feedId, resourcePath);
        if (!this.security.canDelete(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).delete();
        return Response.noContent().build();
    }

    protected CanonicalPath composeCanonicalPath(String tenantId, String envId, String feedId, String resourcePath) {
        CanonicalPath.Extender parent = CanonicalPath.empty().extend(Tenant.SEGMENT_TYPE, tenantId);
        parent = feedId != null ? parent.extend(Feed.SEGMENT_TYPE, feedId) : parent.extend(Environment.SEGMENT_TYPE, envId);
        return CanonicalPath.fromPartiallyUntypedString((String)(parent.get().toString() + "/" + resourcePath), (CanonicalPath)parent.get(), (SegmentType)Resource.SEGMENT_TYPE);
    }

    @GET
    @Path(value="/{environmentId}/resources/{resourcePath:.+}/recursiveChildren")
    @ApiOperation(value="Recursively retrieves child resources of a resource of given type. Can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getRecursiveChildren(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @QueryParam(value="typeId") String resourceTypeId, @Context UriInfo uriInfo) {
        Page rs = this.getRecursiveChildren(environmentId, null, resourcePath, resourceTypeId, true, RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, rs).build();
    }

    @GET
    @Path(value="/feeds/{feedId}/resources/{resourcePath:.+}/recursiveChildren")
    @ApiOperation(value="Recursively retrieves child resources of a resource of given type. Can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getRecursiveChildren(@PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @QueryParam(value="typeId") String resourceTypeId, @QueryParam(value="feedlessType") @DefaultValue(value="false") boolean feedlessType, @Context UriInfo uriInfo) {
        Page rs = this.getRecursiveChildren(null, feedId, resourcePath, resourceTypeId, feedlessType, RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, rs).build();
    }

    private Page<Resource> getRecursiveChildren(String environmentId, String feedId, String resourcePath, String resourceTypeId, boolean feedlessResourceType, Pager pager) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        Filter[][] resourceFilter = new Filter[][]{};
        if (resourceTypeId != null) {
            CanonicalPath resourceTypePath = feedlessResourceType ? (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).resourceType(resourceTypeId)).get() : (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).resourceType(resourceTypeId)).get();
            resourceFilter = new Filter[][]{{Related.asTargetBy((Relationships.WellKnown)Relationships.WellKnown.defines), With.path((CanonicalPath)resourceTypePath)}};
        }
        return ((Resources.Multiple)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).recursiveResources().getAll((Filter[][])resourceFilter)).entities(pager);
    }
}

