/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.interceptors;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.cdi.AutoTenant;
import org.hawkular.inventory.rest.security.TenantId;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;

@Provider
@ServerInterceptor
public class AutocreateTenantRequestFilter
implements ContainerRequestFilter {
    private static final RestApiLogger log = (RestApiLogger)Logger.getMessageLogger(RestApiLogger.class, (String)AutocreateTenantRequestFilter.class.getName());
    private final Set<String> existingTenantIds = ConcurrentHashMap.newKeySet();
    @Inject
    @TenantId
    private String tenantId;
    @Inject
    @AutoTenant
    private Inventory inventory;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        log.tracef("Checking if tenant [%s] needs to be auto-created", (Object)this.tenantId);
        if (this.tenantId != null) {
            if (!this.existingTenantIds.contains(this.tenantId)) {
                log.tracef("Tenant [%s] needs to be created", (Object)this.tenantId);
                try {
                    this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(this.tenantId)).build());
                    log.tracef("Tenant [%s] auto-created sucessfully", (Object)this.tenantId);
                    this.existingTenantIds.add(this.tenantId);
                }
                catch (EntityAlreadyExistsException e) {
                    log.tracef("Tenant [%s] could not be auto-created because it existed in the backedn already", (Object)this.tenantId);
                    this.existingTenantIds.add(this.tenantId);
                }
            } else {
                log.tracef("Tenant [%s] exists already", (Object)this.tenantId);
            }
        }
    }
}

