/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.rest.RestEvents;
import org.hawkular.inventory.rest.cdi.AutoTenant;
import org.hawkular.inventory.rest.cdi.Our;
import org.hawkular.inventory.websocket.WebsocketApiLogger;
import org.hawkular.inventory.websocket.WebsocketEvents;
import rx.Subscription;

@ApplicationScoped
@ServerEndpoint(value="/ws/events")
public class WebsocketEvents {
    private Map<Session, Subscription> subscriptions = Maps.newHashMap();
    @Inject
    @AutoTenant
    protected Inventory inventory;
    @Inject
    @Our
    protected ObjectMapper mapper;

    @OnOpen
    public void open(Session session) {
        Action.Enumerated actionEnumItem;
        WebsocketApiLogger.LOGGER.sessionOpened(session.getId());
        Map queryParamStringMap = this.parseQueryParams(session);
        String type = queryParamStringMap.getOrDefault(QueryParam.type.name(), QueryParam.type.getDefaultValue());
        String actionString = queryParamStringMap.getOrDefault(QueryParam.action.name(), QueryParam.action.getDefaultValue());
        String tenantId = queryParamStringMap.getOrDefault(QueryParam.tenantId.name(), QueryParam.tenantId.getDefaultValue());
        if (tenantId == null) {
            session.getAsyncRemote().sendText("Provide the tenantId query parameter.");
            this.closeSession(session);
            return;
        }
        Class cls = Inventory.getEntityType((String)type);
        if (cls == null) {
            session.getAsyncRemote().sendText("Unknown type: " + type);
            this.closeSession(session);
            return;
        }
        try {
            actionEnumItem = Action.Enumerated.valueOf((String)actionString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            Optional<String> allowedValues = Arrays.stream(Action.Enumerated.values()).map(a -> a.name().toLowerCase() + " ").reduce(String::concat);
            session.getAsyncRemote().sendText("Unknown action: " + actionString + ", allowed values: " + allowedValues.get());
            this.closeSession(session);
            return;
        }
        Action action = actionEnumItem.getAction();
        Subscription subscription = this.inventory.observable(Interest.in((Class)cls).being(action)).filter(RestEvents.getFilter((Action)action, (String)tenantId)).subscribe(x -> {
            try {
                session.getAsyncRemote().sendText(this.mapper.writeValueAsString(x));
            }
            catch (JsonProcessingException e) {
                session.getAsyncRemote().sendText("Unable to serialize JSON.");
                WebsocketApiLogger.LOGGER.serializationFailed((Throwable)e);
                this.closeSession(session);
            }
        });
        this.subscriptions.put(session, subscription);
    }

    @OnClose
    public void close(Session session) {
        WebsocketApiLogger.LOGGER.sessionClosed(session.getId());
        Subscription subscription = (Subscription)this.subscriptions.get(session);
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
        }
    }

    @OnError
    public void onError(Throwable error) {
        WebsocketApiLogger.LOGGER.errorHappened(error);
    }

    @OnMessage
    public void handleMessage(String message, Session session) {
        WebsocketApiLogger.LOGGER.onMessage(session.getId(), message);
    }

    private void closeSession(Session session) {
        try {
            session.close();
        }
        catch (IOException exception) {
            WebsocketApiLogger.LOGGER.sessionCloseFailed((Throwable)exception);
        }
    }

    private Map<String, String> parseQueryParams(Session session) {
        HashMap retMap = Maps.newHashMap();
        String query = session.getQueryString();
        if (query != null) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] nameval = param.split("=");
                retMap.put(nameval[0], nameval[1]);
            }
        }
        return retMap;
    }

    public static Map<String, String> getQueryMap(String query) {
        HashMap map = Maps.newHashMap();
        if (query != null) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] nameval = param.split("=");
                map.put(nameval[0], nameval[1]);
            }
        }
        return map;
    }
}

