/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.HawkularInventoryGetUriLexer;
import org.hawkular.inventory.rest.HawkularInventoryGetUriParser;
import org.hawkular.inventory.rest.Traverser;
import org.hawkular.inventory.rest.Utils;

public final class Traverser {
    private final int indexPrefixSize;
    private final Query.Builder queryPrefix;
    private final Function<String, CanonicalPath> cpParser;

    public Traverser(int indexPrefixSize, Query.Builder queryPrefix, Function<String, CanonicalPath> cpParser) {
        this.indexPrefixSize = indexPrefixSize;
        this.queryPrefix = queryPrefix;
        this.cpParser = cpParser;
    }

    public Query navigate(String traversal) {
        HawkularInventoryGetUriLexer lexer = new HawkularInventoryGetUriLexer((CharStream)new ANTLRInputStream(traversal));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HawkularInventoryGetUriParser parser = new HawkularInventoryGetUriParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        Query.Builder copy = this.queryPrefix.build().asBuilder();
        ParseListener listener = new ParseListener(this, copy, null);
        try {
            HawkularInventoryGetUriParser.UriContext ctx = parser.uri();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)listener, (ParseTree)ctx);
            return listener.getParsedQuery();
        }
        catch (ParseCancellationException e) {
            Throwable error = e.getCause();
            if (error instanceof RecognitionException) {
                RecognitionException re = (RecognitionException)error;
                int errorIndex = this.indexPrefixSize + re.getOffendingToken().getTokenIndex();
                String errorToken = re.getOffendingToken().getText();
                String expectedAlternatives = re.getExpectedTokens() == null ? "none" : re.getExpectedTokens().toString(HawkularInventoryGetUriLexer.VOCABULARY);
                throw new IllegalArgumentException("Illegal inventory traversal URL. Token '" + errorToken + "' on index " + errorIndex + " is not legal. Expected " + expectedAlternatives);
            }
            throw new IllegalArgumentException("Illegal inventory traversal URL. Error message: " + e.getCause().getMessage(), e.getCause());
        }
    }

    private <C extends RuleContext> Map<String, List<ValueAndPos>> extractFilters(List<C> filterContexts, Function<C, RuleContext> filterName, Function<C, RuleContext> filterValue) {
        LinkedHashMap<String, List<ValueAndPos>> ret = new LinkedHashMap<String, List<ValueAndPos>>();
        int pos = 0;
        for (RuleContext ctx : filterContexts) {
            RuleContext nameCtx = filterName.apply(ctx);
            RuleContext valueCtx = filterValue.apply(ctx);
            String name = nameCtx.getText();
            String value = valueCtx.getText();
            ArrayList<ValueAndPos> values = (ArrayList<ValueAndPos>)ret.get(name);
            if (values == null) {
                values = new ArrayList<ValueAndPos>();
                ret.put(name, values);
            }
            values.add(new ValueAndPos(value, pos++, null));
        }
        return ret;
    }

    private Class<? extends Entity<?, ?>>[] getTypes(String[] typeFilterValues) {
        List<Class> typeList = Stream.of(typeFilterValues).map(v -> {
            SegmentType t = Utils.getSegmentTypeFromSimpleName((String)v);
            return Entity.entityTypeFromSegmentType((SegmentType)t);
        }).collect(Collectors.toList());
        return typeList.toArray(new Class[typeList.size()]);
    }

    static /* synthetic */ Map access$100(Traverser x0, List x1, Function x2, Function x3) {
        return x0.extractFilters(x1, x2, x3);
    }

    static /* synthetic */ Function access$200(Traverser x0) {
        return x0.cpParser;
    }

    static /* synthetic */ Class[] access$300(Traverser x0, String[] x1) {
        return x0.getTypes(x1);
    }
}

