/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.integrated.inventory;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.hawkular.inventory.cdi.InventoryConfigurationData;

@Singleton
public class InventoryConfigurationProducer {
    public static final String EXTERNAL_CONF_FILE_PROPERTY_NAME = "hawkular-inventory.conf";

    @Produces
    public InventoryConfigurationData getConfigurationData() throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String prop : System.getProperties().stringPropertyNames()) {
            props.put(prop, System.getProperties().getProperty(prop));
        }
        return new InventoryConfigurationData(this.getConfigurationFile(), props);
    }

    private URL getConfigurationFile() throws IOException {
        File confFile;
        String confFileName = System.getProperty(EXTERNAL_CONF_FILE_PROPERTY_NAME);
        if (confFileName == null) {
            confFile = new File(System.getProperty("user.home"), ".hawkular-inventory.conf");
            if (!confFile.exists()) {
                confFile = null;
            }
        } else {
            confFile = new File(confFileName);
        }
        return confFile == null ? this.getClass().getClassLoader().getResource("hawkular-inventory.properties") : confFile.toURI().toURL();
    }
}

