/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.deprecated;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@javax.ws.rs.Path(value="/deprecated")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/deprecated", description="Manages associations between environments and feeds", tags={"Deprecated"})
public class RestEnvironmentsFeeds
extends RestBase {
    @POST
    @javax.ws.rs.Path(value="/{environmentId}/feeds")
    @ApiOperation(value="Associates a pre-existing feed with an environment")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Feed is already associated with another environment", response=ApiError.class), @ApiResponse(code=404, message="Tenant, environment or one of the feeds doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateFeeds(@PathParam(value="environmentId") String environmentId, @ApiParam(value="A list of paths to feeds to be associated with the environment. They can either be canonical or relative to the environment.") Collection<String> feedPaths) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath env = tenant.extend(Environment.SEGMENT_TYPE, environmentId).get();
        if (!this.security.canAssociateFrom(env)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Feeds.ReadAssociate feeds = (Feeds.ReadAssociate)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).feeds();
        feedPaths.stream().map(p -> Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenant, (CanonicalPath)env, (SegmentType)Feed.SEGMENT_TYPE)).forEach(x$0 -> feeds.associate(x$0));
        return Response.noContent().build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/feeds")
    @ApiOperation(value="Retrieves all feeds associated with an environment. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of feeds"), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedFeeds(@PathParam(value="environmentId") String environmentId, @Context UriInfo uriInfo) {
        Page ms = ((Feeds.Multiple)((Feeds.ReadAssociate)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).environments()).get((Object)environmentId)).feeds()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ms).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/feeds/{feedPath:.+}")
    @ApiOperation(value="Retrieves a single feed associated with an environment")
    @ApiResponses(value={@ApiResponse(code=200, message="The feed"), @ApiResponse(code=404, message="Tenant, environment or feed does not exist or the feed is not associated with the environment", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedFeed(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="feedPath") String feedPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if feed path should be considered canonical, false by default.") boolean isCanonical) {
        Path fp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath env = (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get();
        if (isCanonical) {
            feedPath = "/" + feedPath;
        }
        if (RequestUtil.isTenantEscapeAttempt((CanonicalPath)env, (Path)(fp = Path.fromPartiallyUntypedString((String)feedPath, (CanonicalPath)tenant, (CanonicalPath)env, (SegmentType)Feed.SEGMENT_TYPE)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Feed f = (Feed)((Feeds.Single)((Feeds.ReadAssociate)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).feeds()).get((Object)fp)).entity();
        return Response.ok((Object)f).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/feeds/{feedPath:.+}")
    @ApiOperation(value="Disassociates the given resource from the given metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateFeed(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="feedPath") String feedPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path fp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath env = (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).get();
        if (isCanonical) {
            feedPath = "/" + feedPath;
        }
        if (RequestUtil.isTenantEscapeAttempt((CanonicalPath)env, (Path)(fp = Path.fromPartiallyUntypedString((String)feedPath, (CanonicalPath)tenant, (CanonicalPath)env, (SegmentType)Feed.SEGMENT_TYPE)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Feeds.ReadAssociate)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).feeds()).disassociate(fp);
        return Response.noContent().build();
    }
}

