/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.cdi;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.commons.rest.status.RestStatusInfo;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.cdi.InventoryConfigurationData;
import org.hawkular.inventory.cdi.OfficialInventoryProducer;
import org.hawkular.inventory.rest.cdi.AutoTenant;

@RequestScoped
public class RestStatusDetailsProducer {
    @Inject
    @AutoTenant
    private Instance<Inventory> inventory;
    @Inject
    private Instance<InventoryConfigurationData> configData;

    @Produces
    @RestStatusInfo
    public Map<String, String> getRestStatusDetails() throws IOException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Initialized", Boolean.toString(!this.inventory.isUnsatisfied()));
        if (!this.configData.isUnsatisfied()) {
            Properties props = new Properties();
            try (Reader conf = ((InventoryConfigurationData)this.configData.get()).open();){
                props.load(conf);
                Configuration config = Configuration.builder().withConfiguration(props).build();
                String implClass = config.getProperty(OfficialInventoryProducer.IMPL_PROPERTY, null);
                if (implClass == null) {
                    implClass = ServiceLoader.load(Inventory.class).iterator().next().getClass().getName();
                }
                ret.put("Inventory-Implementation", implClass);
            }
        }
        return ret;
    }
}

