/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.integrated.inventory;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.hawkular.integrated.inventory.Log;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.PartiallyApplied;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.cdi.InventoryInitialized;
import rx.Observable;
import rx.functions.Action1;

@ApplicationScoped
public class TemporaryHacks {
    public void install(@Observes InventoryInitialized event) {
        Inventory inventory = event.getInventory();
        Observable tenantCreation = inventory.observable(Interest.in(Tenant.class).being(Action.created()));
        tenantCreation.subscribe((Action1)PartiallyApplied.method((arg_0, arg_1) -> this.createTenantMetadata(arg_0, arg_1)).second((Object)inventory), arg_0 -> ((Log)Log.LOGGER).failedToAutoCreateEntities(arg_0));
        tenantCreation.subscribe((Action1)PartiallyApplied.method((arg_0, arg_1) -> this.createTestEnvironment(arg_0, arg_1)).second((Object)inventory), arg_0 -> ((Log)Log.LOGGER).failedToAutoCreateEntities(arg_0));
    }

    private void createTestEnvironment(Tenant tenant, Inventory inventory) {
        ((Environments.ReadWrite)inventory.inspect(tenant).environments()).create((Entity.Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("test")).build());
        Log.LOGGER.autoCreatedEntity("environment", "test", tenant.getId());
    }

    private void createTenantMetadata(Tenant tenant, Inventory inventory) {
        ((ResourceTypes.ReadWrite)inventory.inspect(tenant).resourceTypes()).create((Entity.Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("URL")).build());
        Log.LOGGER.autoCreatedEntity("resource type", "URL", tenant.getId());
        ((MetricTypes.ReadWrite)inventory.inspect(tenant).metricTypes()).create((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("status.code.type")).withUnit(MetricUnit.NONE).build());
        Log.LOGGER.autoCreatedEntity("metric type", "status.code.type", tenant.getId());
        ((MetricTypes.ReadWrite)inventory.inspect(tenant).metricTypes()).create((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("status.duration.type")).withUnit(MetricUnit.MILLI_SECOND).build());
        Log.LOGGER.autoCreatedEntity("metric type", "status.duration.type", tenant.getId());
    }
}

