/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Metric types CRUD")
public class RestMetricTypes
extends RestBase {
    @GET
    @Path(value="/metricTypes")
    @ApiOperation(value="Retrieves all metric types. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@Context UriInfo uriInfo) {
        Page ret = ((MetricTypes.Multiple)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).metricTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @Path(value="/metricTypes/{metricTypeId}")
    @ApiOperation(value="Retrieves a single metric type")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public MetricType get(@PathParam(value="metricTypeId") String metricTypeId) {
        return (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).metricTypes()).get((Object)metricTypeId)).entity();
    }

    @POST
    @Path(value="/metricTypes")
    @ApiOperation(value="Creates a new metric type")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric type successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Metric type already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(@ApiParam(required=true) MetricType.Blueprint metricType, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        if (!this.security.canCreate(MetricType.class).under((CanonicalPath)CanonicalPath.of().tenant(tenantId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metricTypes()).create((Entity.Blueprint)metricType);
        return ResponseUtil.created((UriInfo)uriInfo, (String)metricType.getId()).build();
    }

    @PUT
    @Path(value="/metricTypes/{metricTypeId}")
    @ApiOperation(value="Updates a metric type")
    @ApiResponses(value={@ApiResponse(code=204, message="Metric type successfully updated"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="metricTypeId") String metricTypeId, @ApiParam(required=true) MetricType.Update update) throws Exception {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)CanonicalPath.of().tenant(tenantId).metricType(metricTypeId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metricTypes()).update(metricTypeId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/metricTypes/{metricTypeId}")
    @ApiOperation(value="Deletes a metric type")
    @ApiResponses(value={@ApiResponse(code=204, message="Metric type successfully deleted"), @ApiResponse(code=400, message="Metric type cannot be deleted because of constraints on it", response=ApiError.class), @ApiResponse(code=404, message="Tenant or metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="metricTypeId") String metricTypeId) {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)CanonicalPath.of().tenant(tenantId).metricType(metricTypeId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metricTypes()).delete(metricTypeId);
        return Response.noContent().build();
    }
}

