/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.Security;
import org.hawkular.inventory.rest.filters.ResourceFilters;
import org.hawkular.inventory.rest.json.ApiError;

@javax.ws.rs.Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resources CRUD")
public class RestResources
extends RestBase {
    @POST
    @javax.ws.rs.Path(value="/{environmentId}/resources")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addResource(@PathParam(value="environmentId") String environmentId, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath env = (CanonicalPath)CanonicalPath.of().tenant(tenantId).environment(environmentId).get();
        if (!this.security.canCreate(Resource.class).under(env)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Environments.Single)this.inventory.inspect(env, Environments.Single.class)).feedlessResources()).create((Entity.Blueprint)resource);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/resources/{parentPath:.+}")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addResource(@PathParam(value="environmentId") String environmentId, @PathParam(value="parentPath") String parentPath, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, parentPath);
        if (!this.security.canCreate(Resource.class).under(parent)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).containedChildren()).create((Entity.Blueprint)resource);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addFeedResource(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath feed = (CanonicalPath)CanonicalPath.of().tenant(tenantId).environment(environmentId).feed(feedId).get();
        if (!this.security.canCreate(Resource.class).under(feed)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Feeds.Single)this.inventory.inspect(feed, Feeds.Single.class)).resources()).create((Entity.Blueprint)resource);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{parentPath:.+}")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addFeedResource(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="parentPath") String parentPath, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, feedId, parentPath);
        if (!this.security.canCreate(Resource.class).under(parent)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).containedChildren()).create((Entity.Blueprint)resource);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources")
    @ApiOperation(value="Retrieves resources in the environment, optionally filtering by resource type. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getResources(@PathParam(value="environmentId") String environmentId, @QueryParam(value="type") String typeId, @QueryParam(value="feedless") @DefaultValue(value="false") boolean feedless, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Environments.Single envs = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId);
        Resources.Read rr = feedless ? (ResolvingToMultiple)envs.feedlessResources() : envs.allResources();
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        ResourceFilters filters = new ResourceFilters(tenantId, uriInfo.getQueryParameters());
        Page rs = ((Resources.Multiple)rr.getAll(filters.get())).entities(pager);
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)rs).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources")
    @ApiOperation(value="Retrieves resources in the feed, optionally filtering by resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getResources(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        Resources.ReadWrite rr = (Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId)).feeds()).get((Object)feedId)).resources();
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        ResourceFilters filters = new ResourceFilters(tenantId, uriInfo.getQueryParameters());
        Page rs = ((Resources.Multiple)rr.getAll(filters.get())).entities(pager);
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)rs).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Resource getResource(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath) {
        return (Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).environments()).get((Object)environmentId)).feedlessResources()).get((Object)resourcePath)).entity();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Resource getResource(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath) {
        return (Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).environments()).get((Object)environmentId)).feeds()).get((Object)feedId)).resources()).get((Object)resourcePath)).entity();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Retrieves child resources of a resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getChildren(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allChildren()).getAll(new Filter[0])).entities(pager);
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Retrieves child resources of a resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getChildren(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allChildren()).getAll(new Filter[0])).entities(pager);
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/parents")
    @ApiOperation(value="Retrieves parents resources of the resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getParents(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).parents().getAll(new Filter[0])).entities(pager);
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/parents")
    @ApiOperation(value="Retrieves parent resources of a resource. This can be paged.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response getParents(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        Page ret = ((Resources.Multiple)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).parents().getAll(new Filter[0])).entities(pager);
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/parent")
    @ApiOperation(value="Retrieves the parent resources that contains the given resource. Such parent resource will not exist for resources directly contained in an environment or a feed.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment or the resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Resource getParent(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        return (Resource)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).parent().entity();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/parent")
    @ApiOperation(value="Retrieves the parent resources that contains the given resource. Such parent resource will not exist for resources directly contained in an environment or a feed.")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of child resources"), @ApiResponse(code=404, message="environment, feed or the resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Resource getParent(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        return (Resource)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).parent().entity();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Associates given resources as children of a given resource.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response associateChildren(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="resources") Collection<Path> resources) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        Resources.ReadAssociate access = (Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allChildren();
        resources.forEach(x$0 -> access.associate(x$0));
        return Response.noContent().build();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/children")
    @ApiOperation(value="Associates given resources as children of a given resource.")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="environment or the parent resource not found"), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response associateChildren(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="resources") Collection<Path> resources) {
        String tenantId = this.getTenantId();
        CanonicalPath parent = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        Resources.ReadAssociate access = (Resources.ReadAssociate)((Resources.Single)this.inventory.inspect(parent, Resources.Single.class)).allChildren();
        resources.forEach(x$0 -> access.associate(x$0));
        return Response.noContent().build();
    }

    @PUT
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Update a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath, @ApiParam(required=true) Resource.Update update) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canUpdate(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.inventory.inspect(resource, ResolvableToSingle.class).update((Object)update);
        return Response.noContent().build();
    }

    @PUT
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Update a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, @ApiParam(required=true) Resource.Update update) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (!this.security.canUpdate(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).update((Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Deletes a single resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteResource(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canDelete(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).delete();
        return Response.noContent().build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteResource(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath) {
        String tenantId = this.getTenantId();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (!this.security.canDelete(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).delete();
        return Response.noContent().build();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics/")
    @ApiOperation(value="Associates a pre-existing metric with a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateMetrics(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="A list of paths to metrics to be associated with the resource. They can either be canonical or relative to the resource.") Collection<String> metricPaths) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)CanonicalPath.of().tenant(tenantId).get();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canAssociateFrom(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metrics.ReadAssociate metricDao = (Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics();
        metricPaths.stream().map(p -> Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenant, (CanonicalPath)resource, Metric.class)).forEach(x$0 -> metricDao.associate(x$0));
        return Response.noContent().build();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics/")
    @ApiOperation(value="Associates a pre-existing metric with a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateMetrics(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, Collection<String> metricPaths) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)CanonicalPath.of().tenant(tenantId).get();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (!this.security.canAssociateFrom(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metrics.ReadAssociate metricDao = (Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics();
        metricPaths.stream().map(p -> Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenant, (CanonicalPath)resource, Metric.class)).forEach(x$0 -> metricDao.associate(x$0));
        return Response.noContent().build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetrics(@PathParam(value="environmentId") String environmentID, @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        CanonicalPath resource = this.composeCanonicalPath(this.getTenantId(), environmentID, null, resourcePath);
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ms).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetrics(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        CanonicalPath resource = this.composeCanonicalPath(this.getTenantId(), environmentId, feedId, resourcePath);
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ms).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Retrieves a single metric associated with a resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath, @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)CanonicalPath.of().tenant(tenantId).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (Security.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).get((Object)mp)).entity();
        return Response.ok((Object)m).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, feed, resource or metric doesn't exist or if the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)CanonicalPath.of().tenant(tenantId).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (Security.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).get((Object)mp)).entity();
        return Response.ok((Object)m).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Disassociates the given resource from the given metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="resourcePath") String resourcePath, @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)CanonicalPath.of().tenant(tenantId).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canAssociateFrom(rp)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (Security.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).disassociate(mp);
        return Response.noContent().build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Disassociates the given resource from the given metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourcePath") String resourcePath, @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)CanonicalPath.of().tenant(tenantId).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (!this.security.canAssociateFrom(rp)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (Security.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).disassociate(mp);
        return Response.noContent().build();
    }

    private CanonicalPath composeCanonicalPath(String tenantId, String envId, String feedId, String resourcePath) {
        CanonicalPath.Extender bld = CanonicalPath.empty().extend(Tenant.class, tenantId).extend(Environment.class, envId);
        if (feedId != null) {
            bld = bld.extend(Feed.class, feedId);
        }
        bld = bld.extend(Resource.class, resourcePath);
        return bld.get();
    }

    private RelativePath getResourcePath(String path) {
        RelativePath.Extender ret = RelativePath.empty();
        for (String s : path.split("(?<=[^\\\\])/")) {
            ret.extend(Resource.class, s);
        }
        return ret.get();
    }
}

