/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.rest.Security;

public class RelationshipJacksonDeserializer
extends JsonDeserializer<Relationship> {
    public Relationship deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String id = node.get("id") != null ? node.get("id").asText() : null;
        String name = "";
        if (node.get("name") != null) {
            name = node.get("name").asText();
        }
        CanonicalPath source = null;
        CanonicalPath target = null;
        if (node.get("source") != null && !node.get("source").asText().isEmpty()) {
            String sourcePath = node.get("source").asText();
            source = CanonicalPath.fromString((String)sourcePath);
        }
        if (node.get("target") != null && !node.get("target").asText().isEmpty()) {
            String targetPath = node.get("target").asText();
            target = CanonicalPath.fromString((String)targetPath);
        }
        JsonNode properties = node.get("properties");
        Map<String, Object> relProperties = null;
        if (properties != null) {
            try {
                Stream<Map.Entry> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(properties.fields(), 16), false);
                relProperties = stream.collect(Collectors.toMap(Map.Entry::getKey, ((Function<Map.Entry, JsonNode>)Map.Entry::getValue).andThen(x -> x.asText())));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error during relationship deserialization, unable to recognize properties: " + properties);
            }
        }
        return new Relationship(id, name, source, target, relProperties);
    }

    private void validatePath(String path) {
        if (!Security.isValidRestPath((String)path)) {
            throw new IllegalArgumentException("Error during relationship deserialization, unable to recognize following path: " + path);
        }
    }
}

