/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.integrated.inventory;

import java.util.IdentityHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.hawkular.integrated.inventory.Log;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.bus.BusIntegration;
import org.hawkular.inventory.bus.Configuration;
import org.hawkular.inventory.cdi.DisposingInventory;
import org.hawkular.inventory.cdi.InventoryInitialized;

@ApplicationScoped
public class BusIntegrationProducer {
    private final IdentityHashMap<Inventory, BusIntegration> integrations = new IdentityHashMap();

    public void install(@Observes InventoryInitialized event) throws JMSException, NamingException {
        BusIntegration integration = (BusIntegration)this.integrations.get(event.getInventory());
        if (integration == null) {
            integration = this.newIntegration(event.getInventory());
            this.integrations.put(event.getInventory(), integration);
        }
    }

    public void close(@Observes DisposingInventory event) throws NamingException {
        BusIntegration integration = (BusIntegration)this.integrations.remove(event.getInventory());
        if (integration != null) {
            integration.stop();
        }
    }

    private BusIntegration newIntegration(Inventory inventory) {
        BusIntegration ret = new BusIntegration(inventory);
        ret.configure(Configuration.getDefaultConfiguration());
        try {
            ret.start();
        }
        catch (JMSException | NamingException e) {
            Log.LOGGER.busInitializationFailed(e);
        }
        return ret;
    }
}

