/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.PartiallyApplied;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.cdi.DisposingInventory;
import org.hawkular.inventory.cdi.InventoryInitialized;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.Security;
import org.hawkular.inventory.rest.SecurityIntegration;
import rx.Subscription;
import rx.functions.Action1;

@ApplicationScoped
public class SecurityIntegration {
    @Inject
    ResourceService storage;
    @Inject
    PersonaService personas;
    private final Set<Subscription> subscriptions = new HashSet();

    public void start(@Observes InventoryInitialized event) {
        Inventory inventory = event.getInventory();
        this.install(inventory, Tenant.class);
        this.install(inventory, Environment.class);
        this.install(inventory, Feed.class);
        this.install(inventory, ResourceType.class);
        this.install(inventory, MetricType.class);
        this.install(inventory, Resource.class);
        this.install(inventory, Metric.class);
    }

    public void stop(@Observes DisposingInventory event) {
        this.subscriptions.forEach(Subscription::unsubscribe);
        this.subscriptions.clear();
    }

    private <E extends AbstractElement<?, ?>> void install(Inventory inventory, Class<E> cls) {
        this.subscriptions.add(inventory.observable(Interest.in(cls).being(Action.created())).subscribe((Action1)PartiallyApplied.procedure((arg_0, arg_1) -> this.react(arg_0, arg_1)).second((Object)Action.created())));
        this.subscriptions.add(inventory.observable(Interest.in(cls).being(Action.deleted())).subscribe((Action1)PartiallyApplied.procedure((arg_0, arg_1) -> this.react(arg_0, arg_1)).second((Object)Action.deleted())));
    }

    @Transactional
    public void react(AbstractElement<?, ?> entity, Action<?, ?> action) {
        switch (1.$SwitchMap$org$hawkular$inventory$api$Action$Enumerated[action.asEnum().ordinal()]) {
            case 1: {
                this.createSecurityResource(entity);
                break;
            }
            case 2: {
                String stableId = Security.getStableId(entity);
                this.storage.delete(stableId);
                RestApiLogger.LOGGER.debugf("Deleted security entity with stable ID '%s' for entity %s", (Object)stableId, entity);
            }
        }
    }

    private void createSecurityResource(AbstractElement<?, ?> entity) {
        RestApiLogger.LOGGER.tracef("Creating security entity for %s", entity);
        org.hawkular.accounts.api.model.Resource parent = this.ensureParent(entity);
        Persona owner = this.establishOwner(parent, this.personas.getCurrent());
        String stableId = Security.getStableId(entity);
        if (this.storage.get(stableId) == null) {
            this.storage.create(stableId, parent, owner);
            RestApiLogger.LOGGER.debugf("Created security entity with stable ID '%s' for entity %s", (Object)stableId, entity);
        }
    }

    private org.hawkular.accounts.api.model.Resource ensureParent(AbstractElement<?, ?> entity) {
        CanonicalPath parentPath = entity.getPath().up();
        if (!parentPath.isDefined()) {
            return null;
        }
        String parentStableId = Security.getStableId((CanonicalPath)parentPath);
        Persona owner = this.personas.getCurrent();
        org.hawkular.accounts.api.model.Resource parent = this.storage.get(parentStableId);
        if (parent == null) {
            parent = this.storage.create(parentStableId, null, owner);
        }
        return parent;
    }

    private Persona establishOwner(org.hawkular.accounts.api.model.Resource resource, Persona current) {
        while (resource != null && resource.getPersona() == null) {
            resource = resource.getParent();
        }
        if (resource != null && resource.getPersona().equals((Object)current)) {
            current = null;
        }
        return current;
    }
}

