/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/tenant")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/tenant", description="Work with the tenant of the current persona")
public class RestTenants
extends RestBase {
    @GET
    @Path(value="/")
    @ApiOperation(value="Retrieves the tenant of the currently logged in persona")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getTenant() {
        String tenantId = this.getTenantId();
        return Response.ok((Object)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).entity()).build();
    }

    @PUT
    @Path(value="/")
    @ApiOperation(value="Updates properties of the current tenant")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateTenant(@ApiParam(required=true) Tenant.Update update) {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)CanonicalPath.of().tenant(tenantId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.inventory.tenants().update((Object)tenantId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/")
    @ApiOperation(value="Deletes the tenant and all its data. Be careful!")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteTenant() {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)CanonicalPath.of().tenant(tenantId).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.inventory.tenants().delete((Object)tenantId);
        return Response.noContent().build();
    }
}

