/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.integrated.inventory;

import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.cdi.Official;

@Startup
@Singleton
public class InventoryJNDIPublisher {
    @Inject
    @Official
    private Inventory inventory;

    @PostConstruct
    public void publishInventory() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            ctx.bind("java:global/Hawkular/Inventory", (Object)this.inventory);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Could not register inventory in JNDI", e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
            }
        }
    }
}

