/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResolvableToSingleWithRelationships;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.RestRelationships;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/path")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/path", description="The endpoint to obtain inventory entities by their canonical path.")
public class RestPath
extends RestBase {
    @Context
    private Providers providers;

    @GET
    @Path(value="/{entityPath:.+}")
    @ApiOperation(value="Return an entity with the provided canonical path")
    @ApiResponses(value={@ApiResponse(code=200, message="The entity", response=Entity.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="The entity doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response get(@PathParam(value="entityPath") String entityPath, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath path = CanonicalPath.fromPartiallyUntypedString((String)uriInfo.getPath(false).substring(5), (CanonicalPath)tenant, Entity.class);
        return Response.ok((Object)this.inventory.inspect(path, ResolvableToSingle.class).entity()).build();
    }

    @GET
    @Path(value="/{entityPath:.+}/relationships")
    @ApiOperation(value="Return an entity with the provided canonical path")
    @ApiResponses(value={@ApiResponse(code=200, message="The entity", response=Entity.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="The entity doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getRelationships(@PathParam(value="entityPath") String entityPath, @DefaultValue(value="both") @QueryParam(value="direction") String direction, @DefaultValue(value="") @QueryParam(value="property") String propertyName, @DefaultValue(value="") @QueryParam(value="propertyValue") String propertyValue, @DefaultValue(value="") @QueryParam(value="named") String named, @DefaultValue(value="") @QueryParam(value="sourceType") String sourceType, @DefaultValue(value="") @QueryParam(value="targetType") String targetType, @DefaultValue(value="false") @QueryParam(value="jsonld") String jsonLd, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        System.out.println(uriInfo);
        String pathString = uriInfo.getPath(false);
        CanonicalPath path = CanonicalPath.fromPartiallyUntypedString((String)pathString.substring(5, pathString.length() - 14), (CanonicalPath)tenant, Entity.class);
        RelationFilter[] filters = RestRelationships.extractFilters((String)propertyName, (String)propertyValue, (String)named, (String)sourceType, (String)targetType, (UriInfo)uriInfo);
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        ResolvableToSingleWithRelationships resolvable = (ResolvableToSingleWithRelationships)this.inventory.inspect(path, ResolvableToSingleWithRelationships.class);
        Page relations = ((Relationships.Multiple)((Relationships.ReadWrite)resolvable.relationships(Relationships.Direction.valueOf((String)direction))).getAll(filters)).entities(pager);
        boolean jsonLdBool = Boolean.parseBoolean(jsonLd);
        Object json = RestRelationships.getSerializedForm((boolean)jsonLdBool, (Object)relations, (Providers)this.providers);
        if (jsonLdBool) {
            return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)relations, (Object)json).build();
        }
        return this.pagedResponse(Response.ok(), uriInfo, relations).build();
    }
}

