/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Spliterator;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;
import org.hawkular.inventory.bus.Log;
import org.hawkular.inventory.rest.PageToStreamThreadPool;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.json.Link;

/*
 * Exception performing whole class analysis ignored.
 */
final class ResponseUtil {
    ResponseUtil() {
    }

    public static Response.ResponseBuilder created(UriInfo info, String id) {
        return Response.status((Response.Status)Response.Status.CREATED).location(info.getRequestUriBuilder().segment(new String[]{id}).build(new Object[0]));
    }

    public static Response.ResponseBuilder created(UriInfo info, Spliterator<String> ids) {
        return Response.status((Response.Status)Response.Status.CREATED).entity(StreamSupport.stream(ids, false).map(id -> info.getRequestUriBuilder().segment(new String[]{id}).build(new Object[0])));
    }

    public static <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, ObjectMapper mapper, Page<T> page) {
        InputStream data = null;
        try {
            data = ResponseUtil.pageToStream(page, (ObjectMapper)mapper);
        }
        catch (IOException e) {
            Log.LOG.error((Object)e);
        }
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, page, (Object)data);
    }

    public static <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, Page<T> page, Object data) {
        response.entity(data);
        ResponseUtil.createPagingHeader((Response.ResponseBuilder)response, (UriInfo)uriInfo, page);
        return response;
    }

    private static <T> InputStream pageToStream(Page<T> page, ObjectMapper mapper) throws IOException {
        PipedOutputStream outs = new PipedOutputStream();
        1 ins = new /* Unavailable Anonymous Inner Class!! */;
        outs.connect((PipedInputStream)ins);
        mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        PageToStreamThreadPool.getInstance().submit(() -> {
            try (Page closeablePage = page;
                 PipedOutputStream out = outs;
                 SequenceWriter sequenceWriter = mapper.writer().writeValuesAsArray((OutputStream)out);){
                for (Object element : closeablePage) {
                    sequenceWriter.write(element);
                    sequenceWriter.flush();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to convert page to input stream.", e);
            }
        });
        return ins;
    }

    public static void createPagingHeader(Response.ResponseBuilder builder, UriInfo uriInfo, Page<?> resultList) {
        UriBuilder uriBuilder;
        PageContext pc = resultList.getPageContext();
        int page = pc.getPageNumber();
        ArrayList<Link> links = new ArrayList<Link>();
        if (pc.isLimited() && resultList.getTotalSize() > (long)((pc.getPageNumber() + 1) * pc.getPageSize())) {
            int nextPage = page + 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{nextPage});
            links.add(new Link("next", uriBuilder.build(new Object[0]).toString()));
        }
        if (page > 0) {
            int prevPage = page - 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{prevPage});
            links.add(new Link("prev", uriBuilder.build(new Object[0]).toString()));
        }
        if (pc.isLimited()) {
            long lastPage = resultList.getTotalSize() / (long)pc.getPageSize();
            if (resultList.getTotalSize() % (long)pc.getPageSize() == 0L) {
                --lastPage;
            }
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{lastPage});
            links.add(new Link("last", uriBuilder.build(new Object[0]).toString()));
        }
        uriBuilder = uriInfo.getRequestUriBuilder();
        StringBuilder linkHeader = new StringBuilder(new Link("current", uriBuilder.build(new Object[0]).toString()).rfc5988String());
        links.forEach(l -> linkHeader.append(", ").append(l.rfc5988String()));
        builder.header("Link", (Object)linkHeader.toString());
        builder.header("X-Total-Count", (Object)resultList.getTotalSize());
    }
}

