/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="CRUD for resource type data")
public class RestResourceTypesData
extends RestBase {
    @POST
    @Path(value="/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Creates the configuration for pre-existing resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfiguration(@PathParam(value="resourceTypeId") String resourceType, @ApiParam(required=true) DataEntity.Blueprint<ResourceTypes.DataRole> configuration, @Context UriInfo uriInfo) {
        return this.doCreateData(null, null, resourceType, configuration, uriInfo);
    }

    @POST
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Creates the configuration for pre-existing resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant, environment, resource type or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfiguration(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @ApiParam(required=true) DataEntity.Blueprint<ResourceTypes.DataRole> configuration, @Context UriInfo uriInfo) {
        return this.doCreateData(environmentId, feedId, resourceType, configuration, uriInfo);
    }

    @PUT
    @Path(value="/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateData(@PathParam(value="resourceTypeId") String resourceType, @QueryParam(value="dataType") @DefaultValue(value="configurationSchema") ResourceTypes.DataRole dataType, @ApiParam(required=true) DataEntity.Update data) {
        return this.doUpdateData(null, null, resourceType, dataType, data);
    }

    @PUT
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateData(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @QueryParam(value="dataType") @DefaultValue(value="configurationSchema") ResourceTypes.DataRole dataType, @ApiParam(required=true) DataEntity.Update data) {
        return this.doUpdateData(environmentId, feedId, resourceType, dataType, data);
    }

    @DELETE
    @Path(value="/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteData(@PathParam(value="resourceTypeId") String resourceType, @QueryParam(value="dataType") @DefaultValue(value="configurationSchema") ResourceTypes.DataRole dataType) {
        return this.doDeleteData(null, null, resourceType, dataType);
    }

    @DELETE
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteData(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @QueryParam(value="dataType") @DefaultValue(value="configurationSchema") ResourceTypes.DataRole dataType) {
        return this.doDeleteData(environmentId, feedId, resourceType, dataType);
    }

    @GET
    @Path(value="/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public DataEntity get(@PathParam(value="resourceTypeId") String resourceTypeId, @QueryParam(value="dataType") @DefaultValue(value="configurationSchema") ResourceTypes.DataRole dataType) {
        return this.doGetDataEntity(null, null, resourceTypeId, dataType);
    }

    @GET
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/data")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public DataEntity get(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @QueryParam(value="dataType") @DefaultValue(value="configurationSchema") ResourceTypes.DataRole dataType) {
        return this.doGetDataEntity(environmentId, feedId, resourceTypeId, dataType);
    }

    private Response doCreateData(String environmentId, String feedId, String resourceTypeId, DataEntity.Blueprint<ResourceTypes.DataRole> blueprint, UriInfo uriInfo) {
        CanonicalPath resourceType = this.getResourceTypePath(environmentId, feedId, resourceTypeId);
        if (!this.security.canUpdate(resourceType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Data.ReadWrite)((ResourceTypes.Single)this.inventory.inspect(resourceType, ResourceTypes.Single.class)).data()).create(blueprint);
        return ResponseUtil.created((UriInfo)uriInfo, (String)blueprint.getRole().name()).build();
    }

    private Response doUpdateData(String environmentId, String feedId, String resourceTypeId, ResourceTypes.DataRole dataType, DataEntity.Update update) {
        CanonicalPath resourceType = this.getResourceTypePath(environmentId, feedId, resourceTypeId);
        if (!this.security.canUpdate(resourceType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Data.ReadWrite)((ResourceTypes.Single)this.inventory.inspect(resourceType, ResourceTypes.Single.class)).data()).update((DataEntity.Role)dataType, update);
        return Response.noContent().build();
    }

    private Response doDeleteData(String environmentId, String feedId, String resourceTypeId, ResourceTypes.DataRole dataType) {
        CanonicalPath resourceType = this.getResourceTypePath(environmentId, feedId, resourceTypeId);
        if (!this.security.canUpdate(resourceType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Data.ReadWrite)((ResourceTypes.Single)this.inventory.inspect(resourceType, ResourceTypes.Single.class)).data()).delete((Object)dataType);
        return Response.noContent().build();
    }

    private DataEntity doGetDataEntity(String environmentId, String feedId, String resourceTypeId, ResourceTypes.DataRole dataType) {
        return ((Data.Single)((Data.ReadWrite)((ResourceTypes.Single)this.inventory.inspect(this.getResourceTypePath(environmentId, feedId, resourceTypeId), ResourceTypes.Single.class)).data()).get((Object)dataType)).entity();
    }

    private CanonicalPath getResourceTypePath(String environmentId, String feedId, String resourceTypeId) {
        if (environmentId == null) {
            return (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).resourceType(resourceTypeId)).get();
        }
        return (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).environment(environmentId)).feed(feedId)).resourceType(resourceTypeId)).get();
    }
}

