/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Manages associations between resource types and metric types")
public class RestResourceTypesOperationTypes
extends RestBase {
    @POST
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes")
    @ApiOperation(value="Creates a new operation type under a pre-existing resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfiguration(@PathParam(value="resourceTypeId") String resourceType, @ApiParam(required=true) OperationType.Blueprint operationType, @Context UriInfo uriInfo) {
        return this.doCreateData(null, null, resourceType, operationType, uriInfo);
    }

    @POST
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/operationTypes")
    @ApiOperation(value="Creates a new operation type under a pre-existing resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK Created"), @ApiResponse(code=404, message="Tenant, environment, resource type or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createConfiguration(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @ApiParam(required=true) OperationType.Blueprint operationType, @Context UriInfo uriInfo) {
        return this.doCreateData(environmentId, feedId, resourceType, operationType, uriInfo);
    }

    @PUT
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}")
    @ApiOperation(value="Updates the operation type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateData(@PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @ApiParam(required=true) OperationType.Update update) {
        return this.doUpdateData(null, null, resourceType, operationTypeId, update);
    }

    @PUT
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateData(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId, @ApiParam(required=true) OperationType.Update update) {
        return this.doUpdateData(environmentId, feedId, resourceType, operationTypeId, update);
    }

    @DELETE
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteData(@PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId) {
        return this.doDeleteData(null, null, resourceType, operationTypeId);
    }

    @DELETE
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}")
    @ApiOperation(value="Updates the configuration of a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteData(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceType, @PathParam(value="operationTypeId") String operationTypeId) {
        return this.doDeleteData(environmentId, feedId, resourceType, operationTypeId);
    }

    @GET
    @Path(value="/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public OperationType get(@PathParam(value="resourceTypeId") String resourceTypeId, @PathParam(value="operationTypeId") String operationTypeId) {
        return this.doGetDataEntity(null, null, resourceTypeId, operationTypeId);
    }

    @GET
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}/operationTypes/{operationTypeId}")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public OperationType get(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @PathParam(value="operationTypeId") String operationTypeId) {
        return this.doGetDataEntity(environmentId, feedId, resourceTypeId, operationTypeId);
    }

    private Response doCreateData(String environmentId, String feedId, String resourceTypeId, OperationType.Blueprint blueprint, UriInfo uriInfo) {
        CanonicalPath resourceType = this.getResourceTypePath(environmentId, feedId, resourceTypeId);
        if (!this.security.canUpdate(resourceType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((OperationTypes.ReadWrite)((ResourceTypes.Single)this.inventory.inspect(resourceType, ResourceTypes.Single.class)).operationTypes()).create((Blueprint)blueprint);
        return ResponseUtil.created((UriInfo)uriInfo, (String)blueprint.getId()).build();
    }

    private Response doUpdateData(String environmentId, String feedId, String resourceTypeId, String operationTypeId, OperationType.Update update) {
        CanonicalPath operationType = this.getOperationTypePath(environmentId, feedId, resourceTypeId, operationTypeId);
        if (!this.security.canUpdate(operationType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((OperationTypes.Single)this.inventory.inspect(operationType, OperationTypes.Single.class)).update((Object)update);
        return Response.noContent().build();
    }

    private Response doDeleteData(String environmentId, String feedId, String resourceTypeId, String operationTypeId) {
        CanonicalPath operationType = this.getOperationTypePath(environmentId, feedId, resourceTypeId, operationTypeId);
        if (!this.security.canUpdate(operationType)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((OperationTypes.Single)this.inventory.inspect(operationType, OperationTypes.Single.class)).delete();
        return Response.noContent().build();
    }

    private OperationType doGetDataEntity(String environmentId, String feedId, String resourceTypeId, String operationTypeId) {
        return (OperationType)((OperationTypes.Single)this.inventory.inspect(this.getOperationTypePath(environmentId, feedId, resourceTypeId, operationTypeId), OperationTypes.Single.class)).entity();
    }

    private CanonicalPath getOperationTypePath(String environmentId, String feedId, String resourceTypeId, String operationTypeId) {
        if (environmentId == null) {
            return (CanonicalPath)((CanonicalPath.OperationTypeBuilder)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).resourceType(resourceTypeId)).operationType(operationTypeId)).get();
        }
        return (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).environment(environmentId)).feed(feedId)).resourceType(resourceTypeId)).get();
    }

    private CanonicalPath getResourceTypePath(String environmentId, String feedId, String resourceTypeId) {
        if (environmentId == null) {
            return (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).resourceType(resourceTypeId)).get();
        }
        return (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).environment(environmentId)).feed(feedId)).resourceType(resourceTypeId)).get();
    }
}

