/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.ReadInterface;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resource type CRUD")
public class RestResourceTypes
extends RestBase {
    @GET
    @Path(value="/resourceTypes")
    @ApiOperation(value="Retrieves all resource types. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of resource types"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@QueryParam(value="feedless") @DefaultValue(value="false") boolean feedless, @Context UriInfo uriInfo) {
        Tenants.Single tenants = (Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId());
        Page ret = ((ResourceTypes.Multiple)(feedless ? (ReadInterface)tenants.feedlessResourceTypes() : tenants.allResourceTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public ResourceType get(@PathParam(value="resourceTypeId") String resourceTypeId) {
        return (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).feedlessResourceTypes()).get((Object)resourceTypeId)).entity();
    }

    @POST
    @Path(value="/resourceTypes")
    @ApiOperation(value="Creates a new resource type")
    @ApiResponses(value={@ApiResponse(code=201, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource type already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(ResourceType.Blueprint resourceType, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        if (!this.security.canCreate(ResourceType.class).under((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feedlessResourceTypes()).create((Blueprint)resourceType);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resourceType.getId()).build();
    }

    @PUT
    @Path(value="/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Update a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="resourceTypeId") String resourceTypeId, @ApiParam(required=true) ResourceType.Update update) {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).resourceType(resourceTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feedlessResourceTypes()).update((Object)resourceTypeId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Deletes a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="resourceTypeId") String resourceTypeId) {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).resourceType(resourceTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feedlessResourceTypes()).delete((Object)resourceTypeId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{environmentId}/{feedId}/resourceTypes")
    @ApiOperation(value="Retrieves all metric types associated with the resource type. Accepts paging query params.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of metric types associated with the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @Context UriInfo uriInfo) {
        Page ret = ((ResourceTypes.Multiple)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).environments()).get((Object)environmentId)).feeds()).get((Object)feedId)).resourceTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Retrieves all metric types associated with the resource type. Accepts paging query params.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of metric types associated with the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public ResourceType get(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @Context UriInfo uriInfo) {
        return (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).environments()).get((Object)environmentId)).feeds()).get((Object)feedId)).resourceTypes()).get((Object)resourceTypeId)).entity();
    }

    @POST
    @Path(value="/{environmentId}/{feedId}/resourceTypes")
    @ApiOperation(value="Creates a new resource type")
    @ApiResponses(value={@ApiResponse(code=201, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource type already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, ResourceType.Blueprint resourceType, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        if (!this.security.canCreate(ResourceType.class).under((CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).feed(feedId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId)).feeds()).get((Object)feedId)).resourceTypes()).create((Blueprint)resourceType);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resourceType.getId()).build();
    }

    @PUT
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Update a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId, @ApiParam(required=true) ResourceType.Update update) {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).feed(feedId)).resourceType(resourceTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId)).feeds()).get((Object)feedId)).resourceTypes()).update((Object)resourceTypeId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{environmentId}/{feedId}/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Deletes a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceTypeId") String resourceTypeId) {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).environment(environmentId)).feed(feedId)).resourceType(resourceTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).environments()).get((Object)environmentId)).feeds()).get((Object)feedId)).resourceTypes()).delete((Object)resourceTypeId);
        return Response.noContent().build();
    }
}

