/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.security;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.cdi.AutoTenant;
import org.hawkular.inventory.rest.security.EntityIdUtils;
import org.hawkular.inventory.rest.security.InventorySecurity;
import org.hawkular.inventory.rest.security.Security;
import org.hawkular.inventory.rest.security.SecurityIntegration;

@Singleton
@Default
public class InventorySecurity
implements Security {
    private final Map<Class<?>, Map<OperationType, Operation>> operationsByType = new HashMap();
    @Inject
    private PermissionChecker permissions;
    @Inject
    private OperationService operations;
    @Inject
    @AutoTenant
    private Inventory inventory;
    private boolean inventoryInitialized = false;
    @Resource
    private UserTransaction transaction;

    public Security.CreatePermissionCheckerFinisher canCreate(Class<?> entityType) {
        return new CreatePermissionCheckerFinisherImpl(this, entityType, null);
    }

    public boolean canUpdate(CanonicalPath path) {
        return this.safePermissionCheck(path, this.update(path.getSegment().getElementType()));
    }

    public boolean canDelete(CanonicalPath path) {
        return this.safePermissionCheck(path, this.delete(path.getSegment().getElementType()));
    }

    public boolean canAssociateFrom(CanonicalPath path) {
        return this.safePermissionCheck(path, this.associate());
    }

    public boolean canCopyEnvironment(CanonicalPath path) {
        return this.safePermissionCheck(path, this.copy());
    }

    private Operation create(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.CREATE);
    }

    private Operation update(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.UPDATE);
    }

    private Operation delete(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.DELETE);
    }

    private Operation associate() {
        return (Operation)((Map)this.operationsByType.get(Relationship.class)).get(OperationType.ASSOCIATE);
    }

    private Operation copy() {
        return (Operation)((Map)this.operationsByType.get(Environment.class)).get(OperationType.COPY);
    }

    private Operation getOperation(Class<?> cls, OperationType operationType) {
        Map ops = (Map)this.operationsByType.get(cls);
        if (ops == null) {
            throw new IllegalArgumentException("There is no " + operationType + " operation for elements of type " + cls);
        }
        return (Operation)ops.get(operationType);
    }

    private boolean safePermissionCheck(CanonicalPath path, Operation operation) {
        return this.safePermissionCheck(path.getSegment().getElementType(), path.getSegment().getElementId(), operation, EntityIdUtils.getStableId((CanonicalPath)path));
    }

    private boolean safePermissionCheck(Class<?> entityType, String entityId, Operation operation, String stableId) {
        try {
            if (!this.inventoryInitialized) {
                if (!((Tenants.Single)this.inventory.tenants().get((Object)entityId)).exists()) {
                    this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(entityId)).build());
                }
                this.inventoryInitialized = true;
            }
            RestApiLogger.LOGGER.debugf("Permission check for operation '%s' for entity with stable ID '%s'", (Object)operation.getName(), (Object)stableId);
            return this.permissions.isAllowedTo(operation, stableId);
        }
        catch (Exception e) {
            RestApiLogger.LOGGER.securityCheckFailed(stableId, (Throwable)e);
            return false;
        }
    }

    @PostConstruct
    public void initOperationsMap() {
        if (!SecurityIntegration.isDummy()) {
            try {
                this.transaction.begin();
                this.operations.setup("update-tenant").add("SuperUser").persist();
                this.operations.setup("delete-tenant").add("SuperUser").persist();
                this.operations.setup("create-environment").add("Administrator").persist();
                this.operations.setup("update-environment").add("Administrator").persist();
                this.operations.setup("delete-environment").add("Administrator").persist();
                this.operations.setup("copy-environment").add("Administrator").persist();
                this.operations.setup("create-resourceType").add("Administrator").persist();
                this.operations.setup("update-resourceType").add("Administrator").persist();
                this.operations.setup("delete-resourceType").add("Administrator").persist();
                this.operations.setup("create-metricType").add("Administrator").persist();
                this.operations.setup("update-metricType").add("Administrator").persist();
                this.operations.setup("delete-metricType").add("Administrator").persist();
                this.operations.setup("create-operationType").add("Administrator").persist();
                this.operations.setup("update-operationType").add("Administrator").persist();
                this.operations.setup("delete-operationType").add("Administrator").persist();
                this.operations.setup("create-feed").add("Administrator").persist();
                this.operations.setup("update-feed").add("Administrator").persist();
                this.operations.setup("delete-feed").add("Administrator").persist();
                this.operations.setup("create-resource").add("Maintainer").persist();
                this.operations.setup("update-resource").add("Maintainer").persist();
                this.operations.setup("delete-resource").add("Maintainer").persist();
                this.operations.setup("create-metric").add("Maintainer").persist();
                this.operations.setup("update-metric").add("Maintainer").persist();
                this.operations.setup("delete-metric").add("Maintainer").persist();
                this.operations.setup("associate").add("Operator").persist();
                this.transaction.commit();
            }
            catch (Throwable t) {
                try {
                    this.transaction.rollback();
                }
                catch (SystemException e) {
                    throw new IllegalStateException("Unable to do the rollback: " + e.getMessage(), t);
                }
                throw new IllegalStateException(t);
            }
            Operation updateTenantOperation = this.operations.getByName("update-tenant");
            Operation deleteTenantOperation = this.operations.getByName("delete-tenant");
            Operation createEnvironmentOperation = this.operations.getByName("create-environment");
            Operation updateEnvironmentOperation = this.operations.getByName("update-environment");
            Operation deleteEnvironmentOperation = this.operations.getByName("delete-environment");
            Operation copyEnvironmentOperation = this.operations.getByName("copy-environment");
            Operation createResourceTypeOperation = this.operations.getByName("create-resourceType");
            Operation updateResourceTypeOperation = this.operations.getByName("update-resourceType");
            Operation deleteResourceTypeOperation = this.operations.getByName("delete-resourceType");
            Operation createMetricTypeOperation = this.operations.getByName("create-metricType");
            Operation updateMetricTypeOperation = this.operations.getByName("update-metricType");
            Operation deleteMetricTypeOperation = this.operations.getByName("delete-metricType");
            Operation createOperationTypeOperation = this.operations.getByName("create-operationType");
            Operation updateOperationTypeOperation = this.operations.getByName("update-operationType");
            Operation deleteOperationTypeOperation = this.operations.getByName("delete-operationType");
            Operation createFeedOperation = this.operations.getByName("create-feed");
            Operation updateFeedOperation = this.operations.getByName("update-feed");
            Operation deleteFeedOperation = this.operations.getByName("delete-feed");
            Operation createResourceOperation = this.operations.getByName("create-resource");
            Operation updateResourceOperation = this.operations.getByName("update-resource");
            Operation deleteResourceOperation = this.operations.getByName("delete-resource");
            Operation createMetricOperation = this.operations.getByName("create-metric");
            Operation updateMetricOperation = this.operations.getByName("update-metric");
            Operation deleteMetricOperation = this.operations.getByName("delete-metric");
            Operation associate = this.operations.getByName("associate");
            this.operationsByType.put(Tenant.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(Environment.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(ResourceType.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(MetricType.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(Feed.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(org.hawkular.inventory.api.model.Resource.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(Metric.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(Relationship.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(org.hawkular.inventory.api.model.OperationType.class, new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ Operation access$100(InventorySecurity x0, Class x1) {
        return x0.create(x1);
    }

    static /* synthetic */ boolean access$200(InventorySecurity x0, Class x1, String x2, Operation x3, String x4) {
        return x0.safePermissionCheck(x1, x2, x3, x4);
    }
}

