/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/graph")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/graph", description="Retrieves whole graph in the JSON representation.")
public class RestGraphSON
extends RestBase {
    @GET
    @Path(value="/")
    @ApiOperation(value="Gets the graph.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getGraph() {
        String tenantId = this.getTenantId();
        InputStream jsonStream = this.inventory.getGraphSON(tenantId);
        return Response.ok((Object)jsonStream).build();
    }
}

