/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.json.DetypedPathDeserializer;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.RestConfiguration;
import org.hawkular.inventory.rest.Traverser;
import org.hawkular.inventory.rest.Utils;
import org.hawkular.inventory.rest.cdi.AutoTenant;
import org.hawkular.inventory.rest.cdi.Our;
import org.hawkular.inventory.rest.cdi.TenantAware;
import org.hawkular.inventory.rest.security.Security;
import org.hawkular.inventory.rest.security.TenantId;
import org.jboss.resteasy.annotations.GZIP;

@GZIP
public class RestBase {
    @Inject
    @AutoTenant
    protected Inventory inventory;
    @Inject
    protected Security security;
    @Inject
    @TenantId
    private String tenantId;
    @Inject
    Configuration config;
    @Inject
    @Our
    private ObjectMapper deprecatedMapper;
    @Inject
    @TenantAware
    private ObjectMapper defaultMapper;
    private final int pathLength;

    @Deprecated
    protected RestBase() {
        this(0);
    }

    protected RestBase(int pathLength) {
        this.pathLength = pathLength;
    }

    protected <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, Page<T> page) {
        return this.pagedResponse(response, uriInfo, this.getMapper(), page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Response.ResponseBuilder pagedResponse(Response.ResponseBuilder response, UriInfo uriInfo, ObjectMapper mapper, Page<T> page) {
        boolean streaming = this.config.getFlag((Configuration.Property)RestConfiguration.Keys.STREAMING_SERIALIZATION, RestConfiguration.Keys.STREAMING_SERIALIZATION.getDefaultValue());
        if (streaming) {
            return ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, (ObjectMapper)mapper, page);
        }
        try {
            RestApiLogger.LOGGER.debug((Object)"Fetching data from backend");
            List data = page.toList();
            RestApiLogger.LOGGER.debug((Object)"Finished fetching data from backend");
            Response.ResponseBuilder responseBuilder = ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, page, (Object)mapper.writeValueAsString((Object)data));
            return responseBuilder;
        }
        catch (JsonProcessingException e) {
            RestApiLogger.LOGGER.warn((Throwable)e);
            Response.ResponseBuilder responseBuilder = ResponseUtil.pagedResponse((Response.ResponseBuilder)response, (UriInfo)uriInfo, page, (Object)page.toList());
            return responseBuilder;
        }
        finally {
            RestApiLogger.LOGGER.debug((Object)"Finished building paged response (no data sent to client yet)");
        }
    }

    protected String getTenantId() {
        return this.tenantId;
    }

    protected CanonicalPath getTenantPath() {
        return (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get();
    }

    protected CanonicalPath parsePath(List<PathSegment> uriPath) {
        StringBuilder bld = new StringBuilder("/");
        for (PathSegment seg : uriPath) {
            if (seg.getPath() != null) {
                bld.append(seg.getPath());
            }
            if (seg.getMatrixParameters() != null) {
                for (Map.Entry e : seg.getMatrixParameters().entrySet()) {
                    String param = (String)e.getKey();
                    List values = (List)e.getValue();
                    if (values != null && !values.isEmpty()) {
                        for (String val : values) {
                            bld.append(";").append(param);
                            if (val == null) continue;
                            bld.append("=").append(val);
                        }
                        continue;
                    }
                    bld.append(";").append(param);
                }
            }
            bld.append("/");
        }
        bld.replace(bld.length() - 1, bld.length(), "");
        return CanonicalPath.fromPartiallyUntypedString((String)bld.toString(), (CanonicalPath)((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get()), Entity.class);
    }

    protected Traverser getTraverser(UriInfo ctx) {
        Query.Builder queryPrefix = Query.builder().path().with(new Filter[]{With.path((CanonicalPath)((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get()))});
        return new Traverser(ctx.getBaseUri().getPath().length() + this.pathLength, queryPrefix, str -> CanonicalPath.fromPartiallyUntypedString((String)str, (CanonicalPath)this.getTenantPath(), (SegmentType)null));
    }

    protected String getPath(UriInfo uriInfo) {
        return this.getPath(uriInfo, 0);
    }

    protected String getPath(UriInfo uriInfo, int excludeFromEnd) {
        String chopped = uriInfo.getPath(false).substring(this.pathLength);
        if (excludeFromEnd > 0) {
            chopped = chopped.substring(0, chopped.length() - excludeFromEnd);
        }
        return chopped;
    }

    protected Object create(CanonicalPath parentPath, SegmentType elementType, Reader input) throws IOException {
        Class blueprintType = Inventory.types().bySegment(elementType).getBlueprintType();
        JsonNode data = this.getMapper().readTree(input);
        this.setupMapper(parentPath);
        if (data.isArray()) {
            TransactionFrame frame = this.inventory.newTransactionFrame();
            Inventory inv = frame.boundInventory();
            try {
                ArrayList<AbstractElement> result = new ArrayList<AbstractElement>(data.size());
                for (JsonNode datum : data) {
                    Object blueprint = this.getMapper().reader().forType(blueprintType).readValue(datum);
                    AbstractElement entity = Utils.createUnder((Inventory)inv, (CanonicalPath)parentPath, (SegmentType)elementType, (Object)blueprint);
                    result.add(entity);
                }
                frame.commit();
                return result;
            }
            catch (Throwable t) {
                frame.rollback();
                throw t;
            }
        }
        Object blueprint = this.getMapper().reader().forType(blueprintType).readValue(data);
        return Utils.createUnder((Inventory)this.inventory, (CanonicalPath)parentPath, (SegmentType)elementType, (Object)blueprint);
    }

    protected ObjectMapper getMapper() {
        if (this.pathLength == 0) {
            return this.deprecatedMapper;
        }
        return this.defaultMapper;
    }

    protected void setupMapper(CanonicalPath relativePathOrigin) {
        DetypedPathDeserializer.setCurrentCanonicalOrigin((CanonicalPath)this.getTenantPath());
        DetypedPathDeserializer.setCurrentRelativePathOrigin((CanonicalPath)relativePathOrigin);
        DetypedPathDeserializer.setCurrentEntityType(null);
    }
}

