/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.interceptors;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.cdi.AutoTenant;
import org.hawkular.inventory.rest.security.TenantId;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;

@Provider
@ServerInterceptor
public class AutocreateTenantRequestFilter
implements ContainerRequestFilter {
    private static final List<Pattern> uriExceptionPatterns = Stream.of(".*/inventory/status/?", ".*/inventory/ping/?", ".*/inventory/?").map(Pattern::compile).collect(Collectors.toList());
    private static final RestApiLogger log = (RestApiLogger)Logger.getMessageLogger(RestApiLogger.class, (String)AutocreateTenantRequestFilter.class.getName());
    private final Set<String> existingTenantIds = ConcurrentHashMap.newKeySet();
    @Inject
    @TenantId
    private Instance<String> tenantIdProducer;
    @Inject
    @AutoTenant
    private Inventory inventory;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean shouldSkip = this.shouldSkip(requestContext.getUriInfo().getRequestUri().getPath());
        if (shouldSkip) {
            return;
        }
        String tenantId = (String)this.tenantIdProducer.get();
        log.tracef("Checking if tenant [%s] needs to be auto-created", (Object)tenantId);
        if (tenantId != null) {
            if (!this.existingTenantIds.contains(tenantId)) {
                log.tracef("Tenant [%s] needs to be created", (Object)tenantId);
                try {
                    this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build());
                    log.tracef("Tenant [%s] auto-created successfully", (Object)tenantId);
                    this.existingTenantIds.add(tenantId);
                }
                catch (EntityAlreadyExistsException e) {
                    log.tracef("Tenant [%s] could not be auto-created because it existed in the backend already", (Object)tenantId);
                    this.existingTenantIds.add(tenantId);
                }
            } else {
                log.tracef("Tenant [%s] exists already", (Object)tenantId);
            }
        }
    }

    private boolean shouldSkip(String uri) {
        return uriExceptionPatterns.stream().anyMatch(p -> p.matcher(uri).matches());
    }
}

